/*
 * Decompiled with CFR 0.152.
 */
package aljx.java.util.thread;

import aljx.java.util.debug.Tracer;

public abstract class RecurringThread
extends Thread {
    private boolean isRecurring = false;
    private long sleepTime = 0L;

    public synchronized void setRecurring(boolean isRecurring) {
        this.isRecurring = isRecurring;
    }

    public void setSleepTime(long sleepTime) {
        this.sleepTime = sleepTime;
    }

    @Override
    public void run() {
        while (this.isRecurring) {
            this.doWork();
            if (this.sleepTime == 0L) continue;
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException e) {
                Tracer.e(e);
            }
        }
    }

    public abstract void doWork();

    public static RecurringThread launch(final Runnable runnable, long updateTime) {
        RecurringThread recurringThread = new RecurringThread(){

            @Override
            public void doWork() {
                runnable.run();
            }
        };
        recurringThread.setRecurring(true);
        recurringThread.setSleepTime(updateTime);
        recurringThread.start();
        return recurringThread;
    }
}

