/*
 * Decompiled with CFR 0.152.
 */
package aljx.java.util.text.modify;

import aljx.java.util.text.TextUtils;
import aljx.java.util.text.modify.StringModifier;
import java.util.ArrayList;
import java.util.List;

public class WordWrapModifier
implements StringModifier {
    private final int mLineLength;

    public WordWrapModifier(int lineLength) {
        if (lineLength < 1) {
            throw new IllegalArgumentException("Wrong line length = " + lineLength);
        }
        this.mLineLength = lineLength;
    }

    @Override
    public String modify(String string) {
        if (TextUtils.isEmpty(string)) {
            return string;
        }
        List<String> text = TextUtils.splitLines(string);
        StringBuilder sb = new StringBuilder();
        for (String line : text) {
            if (line.length() > this.mLineLength) {
                ArrayList<String> splittedLines = TextUtils.wordWrap(line, this.mLineLength);
                for (String splittedLine : splittedLines) {
                    sb.append(splittedLine).append("\n");
                }
                continue;
            }
            sb.append(line).append("\n");
        }
        return sb.toString();
    }
}

