/*
 * Decompiled with CFR 0.152.
 */
package aljx.java.util.stream;

import aljx.java.util.text.filter.StringFilter;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class StreamReader {
    public static String streamToString(InputStream is) throws IOException {
        return CloseControl.streamToString(is, true);
    }

    public static List<String> streamToStringList(InputStream is) throws IOException {
        return CloseControl.streamToStringList(is, null, true);
    }

    public static List<String> streamToStringList(InputStream is, StringFilter stringFilter) throws IOException {
        return CloseControl.streamToStringList(is, stringFilter, true);
    }

    public static void transferStream(InputStream is, OutputStream os) throws IOException {
        CloseControl.transferStream(is, os, true);
    }

    public static byte[] streamToBytes(InputStream is) throws IOException {
        return CloseControl.streamToBytes(is, true);
    }

    public static void streamToFile(InputStream is, File targetLocation) throws IOException {
        CloseControl.streamToFile(is, targetLocation, true);
    }

    public static class CloseControl {
        private static final boolean PRINT_LOG = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static String streamToString(InputStream is, boolean closeInputStream) throws IOException {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1024];
            try {
                int n;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((n = reader.read(buffer)) != -1) {
                    ((Writer)writer).write(buffer, 0, n);
                }
            }
            finally {
                if (closeInputStream) {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return ((Object)writer).toString();
        }

        public static List<String> streamToStringList(InputStream is, boolean closeInputStream) throws IOException {
            return CloseControl.streamToStringList(is, null, closeInputStream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static List<String> streamToStringList(InputStream is, StringFilter stringFilter, boolean closeInputStream) throws IOException {
            ArrayList<String> list = new ArrayList<String>();
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((line = reader.readLine()) != null) {
                    if (stringFilter != null && !stringFilter.accept(line)) continue;
                    list.add(line);
                }
            }
            finally {
                if (closeInputStream) {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void transferStream(InputStream is, OutputStream os, boolean closeInputStream) throws IOException {
            try {
                byte[] bytes = CloseControl.streamToBytes(is, closeInputStream);
                os.write(bytes, 0, bytes.length);
            }
            finally {
                if (closeInputStream) {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
                try {
                    os.close();
                }
                catch (Exception exception) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static byte[] streamToBytes(InputStream is, boolean closeInputStream) throws IOException {
            ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
            byte[] buffer = new byte[1024];
            try {
                int len;
                while ((len = is.read(buffer)) >= 0) {
                    os.write(buffer, 0, len);
                }
                byte[] byArray = os.toByteArray();
                return byArray;
            }
            finally {
                if (closeInputStream) {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
                try {
                    os.close();
                }
                catch (Exception exception) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void streamToFile(InputStream is, File targetLocation, boolean closeInputStream) throws IOException {
            if (targetLocation.exists()) {
                targetLocation.delete();
            }
            if (targetLocation.exists()) {
                throw new IOException("Filed delete " + targetLocation);
            }
            targetLocation.createNewFile();
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(targetLocation);
                byte[] buffer = new byte[1024];
                int length = 0;
                while ((length = is.read(buffer)) > 0) {
                    ((OutputStream)out).write(buffer, 0, length);
                }
            }
            finally {
                if (closeInputStream) {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
                try {
                    ((OutputStream)out).close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

