/*
 * Decompiled with CFR 0.152.
 */
package aljx.java.util.state;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

public final class ConcurrentCache {
    private static final ConcurrentHashMap<Object, Object> MAP = new ConcurrentHashMap();
    private static final AtomicReference<Object> NULL_KEY = new AtomicReference();

    public <T> T get(Object key) {
        return (T)(key == null ? NULL_KEY.get() : MAP.get(key));
    }

    public <T> T get(Object key, Class<T> tClass) {
        return (T)(key == null ? NULL_KEY.get() : MAP.get(key));
    }

    public <T> T put(Object key, T value) {
        return (T)(key == null ? NULL_KEY.getAndSet(value) : (value == null ? MAP.remove(key) : MAP.put(key, value)));
    }

    public <T> T remove(Object key) {
        return (T)(key == null ? NULL_KEY.getAndSet(null) : MAP.remove(key));
    }

    public void clear() {
        NULL_KEY.set(null);
        MAP.clear();
    }

    public <T> boolean compare(Object key, T value) {
        T storedValue = this.get(key);
        return storedValue == null ? value == null : storedValue.equals(value);
    }
}

