/*
 * Decompiled with CFR 0.152.
 */
package aljx.java.util.reflection;

import aljx.java.util.debug.Dumper;
import aljx.java.util.debug.Tracer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class ObjectDumper {
    public static String dumpFields(Object object) {
        StringBuilder sb = new StringBuilder();
        ObjectDumper.dumpFields(sb, object, new ArrayList());
        return sb.toString();
    }

    public static void dumpFields(StringBuilder sb, Object object, ArrayList dumpedObjects) {
        Class<?> oClass;
        if (object == null) {
            sb.append("null");
            return;
        }
        for (Object dumpedItem : dumpedObjects) {
            if (dumpedItem != object) continue;
            sb.append("duplicate " + object.getClass().getName() + "@" + Integer.toHexString(object.hashCode()));
            return;
        }
        if (object == dumpedObjects) {
            sb.append("duplicate " + object.getClass().getName() + "@" + Integer.toHexString(object.hashCode()));
            return;
        }
        dumpedObjects.add(object);
        Class<?> clazz = oClass = object != null ? object.getClass() : null;
        if (object == null) {
            sb.append("null");
        } else if (oClass.isArray()) {
            sb.append("Array: ");
            sb.append("[");
            for (int i = 0; i < Array.getLength(object); ++i) {
                Object value = Array.get(object, i);
                if (value != null) {
                    if (value.getClass().isPrimitive() || value.getClass() == Long.class || value.getClass() == Integer.class || value.getClass() == Boolean.class || value.getClass() == Double.class || value.getClass() == Float.class || value.getClass() == Short.class || value.getClass() == Character.class || value.getClass() == Byte.class) {
                        sb.append(value);
                        if (i == Array.getLength(object) - 1) continue;
                        sb.append(",");
                        continue;
                    }
                    if (value.getClass() == String.class) {
                        String str = (String)value;
                        sb.append(str != null && str.length() > 1000 ? str.substring(0, 1000) : str);
                        if (i == Array.getLength(object) - 1) continue;
                        sb.append(",");
                        continue;
                    }
                    ObjectDumper.dumpFields(sb, value, dumpedObjects);
                    continue;
                }
                sb.append("null");
            }
            sb.append("]\n");
        } else {
            sb.append("Class: " + oClass.getName());
            sb.append("{\n");
            while (oClass != null) {
                Field[] fields = oClass.getDeclaredFields();
                for (int i = 0; i < fields.length; ++i) {
                    fields[i].setAccessible(true);
                    sb.append(fields[i].getName());
                    sb.append("=");
                    try {
                        Object value = fields[i].get(object);
                        if (value != null) {
                            if (value.getClass().isPrimitive() || value.getClass() == Long.class || value.getClass() == Integer.class || value.getClass() == Boolean.class || value.getClass() == Double.class || value.getClass() == Float.class || value.getClass() == Short.class || value.getClass() == Character.class || value.getClass() == Byte.class) {
                                sb.append(value);
                            } else if (value.getClass() == String.class) {
                                String str = (String)value;
                                sb.append(str != null && str.length() > 1000 ? str.substring(0, 1000) : str);
                            } else {
                                sb.append(Dumper.dump(value, dumpedObjects));
                            }
                        } else {
                            sb.append("null");
                        }
                    }
                    catch (IllegalAccessException e) {
                        sb.append(e.getMessage());
                    }
                    sb.append("\n");
                }
                oClass = oClass.getSuperclass();
            }
            sb.append("}\n");
        }
        dumpedObjects.remove(object);
    }

    public static String dumpMethods(Object object) {
        StringBuilder sb = new StringBuilder();
        ObjectDumper.dumpMethods(sb, object);
        return sb.toString();
    }

    public static String dumpMethods(Class<?> clazz) {
        StringBuilder sb = new StringBuilder();
        ObjectDumper.dumpMethods(sb, clazz);
        return sb.toString();
    }

    public static void dumpMethods(StringBuilder sb, Object object) {
        Class<?> clazz = object != null ? object.getClass() : null;
        ObjectDumper.dumpMethods(sb, clazz);
    }

    public static void dumpMethods(StringBuilder sb, Class<?> clazz) {
        if (clazz == null) {
            sb.append("null");
        } else {
            for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
                sb.append('\n').append('\n').append(clazz.getName()).append(" methods:").append('\n');
                for (Method method : c.getDeclaredMethods()) {
                    sb.append(method);
                    sb.append('\n');
                }
            }
            sb.append('\n');
        }
    }

    public static void printClassAccessInfo(Class<?> caller, Class<?> target) {
        Tracer.i("caller " + caller.getName() + " class loader = " + caller.getClassLoader());
        Tracer.i("target " + target.getName() + " class loader = " + target.getClassLoader());
        ObjectDumper.logString("target class methods:\n" + ObjectDumper.dumpMethods(target));
    }

    public static void logString(String str) {
        if (str.length() > 4000) {
            Tracer.i(str.substring(0, 4000));
            ObjectDumper.logString(str.substring(4000));
        } else {
            Tracer.i(str);
        }
    }
}

