/*
 * Decompiled with CFR 0.152.
 */
package aljx.java.util.file.zip;

import java.io.File;
import java.util.HashMap;

public final class ZipEntryFile {
    private static final boolean PRINT_LOG = false;
    private static final String DUP_SUFFIX = "_dup";
    private static final int DUP_SUFFIX_LENGTH = "_dup".length();
    public final File file;
    private String entryName;

    public ZipEntryFile(File file, String entryName) {
        this.file = file;
        this.entryName = entryName;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public void fixName(HashMap<String, ZipEntryFile> zipArchiveNames) {
        String name = this.entryName;
        if (!(!zipArchiveNames.containsKey(name) || this.file.isDirectory() && zipArchiveNames.get((Object)name).file.isDirectory())) {
            int lastIndexOf = name.lastIndexOf(DUP_SUFFIX);
            if (lastIndexOf > -1) {
                try {
                    Integer num = Integer.valueOf(name.substring(lastIndexOf + DUP_SUFFIX_LENGTH));
                    name = name.substring(0, lastIndexOf + DUP_SUFFIX_LENGTH);
                }
                catch (Exception num) {
                    // empty catch block
                }
            }
            if (!name.endsWith(DUP_SUFFIX)) {
                name = name + DUP_SUFFIX;
            }
            int i = 1;
            while (zipArchiveNames.containsKey(name + i)) {
                ++i;
            }
            name = name + i;
        }
        this.entryName = name;
    }
}

