/*
 * Decompiled with CFR 0.152.
 */
package aljx.java.util.file.filter;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;

public class FileSetFilter
implements FileFilter {
    ArrayList<String> includeList;
    ArrayList<String> excludeList;

    public static FileSetFilter excludeInstance(File ... exclude) {
        return new FileSetFilter(null, exclude);
    }

    public FileSetFilter() {
    }

    public FileSetFilter(File ... include) {
        this(include, (File[])null);
    }

    public FileSetFilter(File[] include, File[] exclude) {
        if (include != null) {
            this.includeList = new ArrayList();
            for (File f : include) {
                this.includeList.add(f.getAbsolutePath());
            }
        }
        if (exclude != null) {
            this.excludeList = new ArrayList();
            for (File f : exclude) {
                this.excludeList.add(f.getAbsolutePath());
            }
        }
    }

    public FileSetFilter(ArrayList<String> includeList, ArrayList<String> excludeList) {
        if (includeList != null) {
            this.includeList = new ArrayList();
            this.includeList.addAll(includeList);
        }
        if (excludeList != null) {
            this.excludeList = new ArrayList();
            this.excludeList.addAll(excludeList);
        }
    }

    @Override
    public boolean accept(File pathname) {
        if (pathname == null) {
            return false;
        }
        String absolutePath = pathname.getAbsolutePath();
        if (this.excludeList != null && this.excludeList.contains(absolutePath)) {
            return false;
        }
        if (this.includeList == null) {
            return true;
        }
        return this.includeList.contains(absolutePath);
    }
}

