/*
 * Decompiled with CFR 0.152.
 */
package aljx.java.util.file;

import aljx.java.util.debug.Tracer;
import java.io.IOException;
import java.io.RandomAccessFile;

public class WavFile {
    public static final int TEN_MB_IN_BYTES = 0xA00000;
    public static final short FORMAT_PCM = 1;
    public static final short FORMAT_ALAW = 6;
    public static final short FORMAT_ULAW = 7;
    private RandomAccessFile mFile = null;

    public WavFile(String filename, short channelsNumber, int sampleRate, short bitsPerSample) throws IOException {
        this(filename, 1, channelsNumber, sampleRate, bitsPerSample);
    }

    public WavFile(String filename, short wavFormat, short channelsNumber, int sampleRate, short bitsPerSample) throws IOException {
        try {
            this.mFile = new RandomAccessFile(filename, "rw");
            this.createHeader(wavFormat, channelsNumber, sampleRate, bitsPerSample);
        }
        catch (IOException e) {
            if (this.mFile != null) {
                try {
                    this.mFile.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.mFile = null;
            }
            throw e;
        }
    }

    public WavFile(String filename) throws IOException {
        try {
            this.mFile = new RandomAccessFile(filename, "rw");
            this.mFile.seek(44L);
        }
        catch (IOException e) {
            if (this.mFile != null) {
                try {
                    this.mFile.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.mFile = null;
            }
            throw e;
        }
    }

    public void close(int savedDataSize) throws IOException {
        try {
            this.mFile.seek(4L);
            this.writeInt(this.mFile, savedDataSize + 36);
            this.mFile.seek(40L);
            this.writeInt(this.mFile, savedDataSize);
        }
        catch (IOException e) {
            Tracer.e(e);
        }
        this.mFile.close();
    }

    public void close() throws IOException {
        try {
            long savedDataSize = this.mFile.getChannel().size() - 44L;
            this.mFile.seek(4L);
            this.writeInt(this.mFile, (int)savedDataSize + 36);
            this.mFile.seek(40L);
            this.writeInt(this.mFile, (int)savedDataSize);
        }
        catch (IOException e) {
            Tracer.e(e);
        }
        this.mFile.close();
    }

    public void write(byte[] buffer, int byteOffset, int byteCount) throws IOException {
        this.mFile.write(buffer, byteOffset, byteCount);
    }

    public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
        return this.mFile.read(buffer, byteOffset, byteCount);
    }

    private void createHeader(short wavFormat, short channelsNumber, int sampleRate, short bitsPerSample) throws IOException {
        this.mFile.setLength(0L);
        this.mFile.writeBytes("RIFF");
        this.writeInt(this.mFile, 0);
        this.mFile.writeBytes("WAVE");
        this.mFile.writeBytes("fmt ");
        this.writeInt(this.mFile, 16);
        this.writeShort(this.mFile, wavFormat);
        this.writeShort(this.mFile, channelsNumber);
        this.writeInt(this.mFile, sampleRate);
        this.writeInt(this.mFile, channelsNumber * sampleRate * bitsPerSample / 8);
        this.writeShort(this.mFile, (short)(channelsNumber * bitsPerSample / 8));
        this.writeShort(this.mFile, bitsPerSample);
        this.mFile.writeBytes("data");
        this.writeInt(this.mFile, 0);
    }

    private void writeInt(RandomAccessFile raf, int val) throws IOException {
        raf.write(val >> 0);
        raf.write(val >> 8);
        raf.write(val >> 16);
        raf.write(val >> 24);
    }

    private void writeShort(RandomAccessFile raf, short val) throws IOException {
        raf.write(val >> 0);
        raf.write(val >> 8);
    }
}

