/*
 * Decompiled with CFR 0.152.
 */
package aljx.java.util.file;

import aljx.java.util.file.FileHelper;
import java.io.File;
import java.io.FileFilter;

public class ListFilesUtils {
    public static final char GO_TO_NEXT_LINE = '\n';
    public static final String F_PREFIX = "[F] : ";
    public static final String D_PREFIX = "[D] : ";
    private static final String FILE_LISTING = " file listing...";
    private static final String EITHER_DIRECTORY_DOES_NOT_EXIST_OR_IS_NOT_A_DIRECTORY = "Either directory does not exist or is not a directory";
    private static final String ERROR_WITH = "Error with ";
    private static final String BYTES = " bytes";
    private static final String SPACE = " ";
    private static final String LINE_SEPARATOR = "----------------------";
    private static final char D_CHAR = 'D';
    private static final StringBuilder sb = new StringBuilder();

    private static void doFileFilterListing(String dirName, String ff) {
        if (dirName == null) {
            return;
        }
        ListFilesUtils.println(LINE_SEPARATOR);
        ListFilesUtils.print(dirName);
        ListFilesUtils.println(FILE_LISTING);
        ListFilesUtils.println(LINE_SEPARATOR);
        final String fileFilter = ff;
        File dir = new File(dirName);
        FileFilter filter = null;
        if (fileFilter != null) {
            filter = new FileFilter(){

                @Override
                public boolean accept(File file) {
                    String name = file.getName();
                    return name.startsWith(fileFilter);
                }
            };
        }
        String[] children = FileHelper.list(dir, filter);
        ListFilesUtils.printFiles(children, dirName);
        File[] listFiles = dir.listFiles();
        if (listFiles != null) {
            for (File f : listFiles) {
                if (f == null || !f.exists() || !f.isDirectory()) continue;
                ListFilesUtils.doFileFilterListing(f.getAbsolutePath(), ff);
            }
        }
    }

    private static void printFiles(String[] children, String dirName) {
        if (children == null) {
            ListFilesUtils.print(ERROR_WITH);
            ListFilesUtils.println(dirName);
            ListFilesUtils.println(EITHER_DIRECTORY_DOES_NOT_EXIST_OR_IS_NOT_A_DIRECTORY);
        } else {
            for (int i = 0; i < children.length; ++i) {
                String filename = children[i];
                if (filename == null) continue;
                File file = new File(dirName, filename);
                if (file.isDirectory()) {
                    ListFilesUtils.print(D_PREFIX);
                    ListFilesUtils.print(dirName);
                    ListFilesUtils.print(File.separator);
                    ListFilesUtils.println(filename);
                    continue;
                }
                ListFilesUtils.print(F_PREFIX);
                ListFilesUtils.print(dirName);
                ListFilesUtils.print(File.separator);
                ListFilesUtils.print(filename);
                ListFilesUtils.print(SPACE);
                ListFilesUtils.print(file.length());
                ListFilesUtils.println(BYTES);
            }
        }
    }

    private static void println(String string) {
        sb.append(string).append('\n');
    }

    private static void print(String string) {
        sb.append(string);
    }

    private static void print(long l) {
        sb.append(l);
    }

    public static String listFiles(File dir) {
        String result = "";
        if (dir != null) {
            sb.setLength(0);
            ListFilesUtils.doFileFilterListing(dir.getAbsolutePath(), null);
            result = sb.toString();
            sb.setLength(0);
        }
        return result;
    }

    public static String listFiles(String dirName) {
        String result = "";
        if (dirName != null) {
            sb.setLength(0);
            ListFilesUtils.doFileFilterListing(dirName, null);
            result = sb.toString();
            sb.setLength(0);
        }
        return result;
    }

    public static String listFiles(String[] dirNames) {
        String result = "";
        if (dirNames != null) {
            sb.setLength(0);
            for (int i = 0; i < dirNames.length; ++i) {
                sb.append('D').append(i).append('\n');
                ListFilesUtils.doFileFilterListing(dirNames[i], null);
            }
            result = sb.toString();
            sb.setLength(0);
        }
        return result;
    }
}

