/*
 * Decompiled with CFR 0.152.
 */
package aljx.java.util.file;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashSet;

public class FileSearcher {
    private static final boolean PRINT_LOG = false;
    private final ArrayList<File> mFileList = new ArrayList();

    public void clear() {
        this.mFileList.clear();
    }

    public static ArrayList<File> find(File file, FileFilter findFilter, FileFilter addFilter) {
        FileSearcher fileSearcher = new FileSearcher();
        fileSearcher.findFiles(file, findFilter, addFilter);
        return fileSearcher.getFileList();
    }

    public void findFiles(File file, FileFilter findFilter, FileFilter addFilter) {
        File[] files;
        if (addFilter == null || addFilter.accept(file)) {
            this.mFileList.add(file);
        }
        if (file.isDirectory() && (files = file.listFiles(findFilter)) != null) {
            for (File subFile : files) {
                this.findFiles(subFile, findFilter, addFilter);
            }
        }
    }

    public ArrayList<File> getFileList() {
        ArrayList<File> list = new ArrayList<File>();
        list.addAll(this.mFileList);
        return list;
    }

    public ArrayList<String> getAbsoluteFileNameList() {
        ArrayList<String> list = new ArrayList<String>();
        for (File f : this.mFileList) {
            list.add(f.getAbsolutePath());
        }
        return list;
    }

    public ArrayList<String> getFileNameList() {
        ArrayList<String> list = new ArrayList<String>();
        HashSet<String> set = new HashSet<String>();
        for (File f : this.mFileList) {
            set.add(f.getName());
        }
        list.addAll(set);
        return list;
    }

    public static ArrayList<String> getDependedFileNameList(ArrayList<File> fileList, File dir) {
        ArrayList<String> list = new ArrayList<String>();
        String dirPath = dir.getAbsolutePath();
        for (File f : fileList) {
            String filePath = f.getAbsolutePath();
            if (!filePath.startsWith(dirPath) || filePath.length() <= dirPath.length()) {
                throw new IllegalArgumentException("Wrong dir = " + dirPath + " for file = " + filePath);
            }
            filePath = filePath.substring(dirPath.length() + 1, filePath.length());
            list.add(filePath);
        }
        return list;
    }
}

