/*
 * Decompiled with CFR 0.152.
 */
package aljx.java.util.file;

import aljx.java.util.file.FileInfo;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class FileInfoSearcher {
    private final ArrayList<FileInfo> mFileList = new ArrayList();
    private static int mFileChecked;

    public static ArrayList<File> getAllInnerFiles(File file) {
        return FileInfoSearcher.getAllInnerFiles(file, null, null);
    }

    public static ArrayList<File> getAllInnerFiles(File file, FileFilter addFilter, FileFilter listFilter) {
        ArrayList<File> fileList = new ArrayList<File>();
        mFileChecked = 0;
        FileInfoSearcher.getAllInnerFiles(file, fileList, addFilter, listFilter);
        mFileChecked = 0;
        return fileList;
    }

    private static void printGetFileProgress() {
        if (++mFileChecked % 1000 == 0) {
            System.out.print('.');
        }
        if (mFileChecked % 100000 == 0) {
            System.out.println();
        }
    }

    private static void getAllInnerFiles(File file, ArrayList<File> fileList, FileFilter addFilter, FileFilter listFilter) {
        if (addFilter == null || addFilter.accept(file)) {
            fileList.add(file);
        }
        FileInfoSearcher.printGetFileProgress();
        if (file.isDirectory()) {
            File[] fileArr;
            File[] fileArray = fileArr = listFilter == null ? file.listFiles() : file.listFiles(listFilter);
            if (fileArr == null) {
                System.out.println("\n null subfiles arr for " + file.getAbsolutePath());
            } else {
                for (File childFile : fileArr) {
                    FileInfoSearcher.getAllInnerFiles(childFile, fileList, addFilter, listFilter);
                }
            }
        }
    }

    public void clear() {
        this.mFileList.clear();
    }

    public int size() {
        return this.mFileList.size();
    }

    public void findFiles(File file) {
        this.mFileList.add(new FileInfo(file));
        if (this.mFileList.size() % 1000 == 0) {
            System.out.print('.');
        }
        if (this.mFileList.size() % 100000 == 0) {
            System.out.println();
        }
        if (file.isDirectory()) {
            File[] fileArr = file.listFiles();
            if (fileArr == null) {
                System.out.println("\n null subfiles arr for " + file.getAbsolutePath());
            } else {
                for (File childFile : fileArr) {
                    this.findFiles(childFile);
                }
            }
        }
    }

    public void saveToFile(File file) throws IOException {
        if (!file.exists()) {
            file.createNewFile();
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        long l = 0L;
        for (FileInfo fi : this.mFileList) {
            bufferedWriter.write(fi.getFileInfoString());
            if (++l % 1000L == 0L) {
                System.out.print('.');
            }
            if (l % 100000L != 0L) continue;
            System.out.println();
        }
        bufferedWriter.close();
        System.out.println("\n " + l + " strings saved");
    }
}

