/*
 * Decompiled with CFR 0.152.
 */
package aljx.java.util.file;

import aljx.java.util.date.DateUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;

public final class FileInfo {
    private final File file;
    public final long fileSize;
    public final boolean isDirectory;
    public final String path;
    public final String name;
    public final long lastModified;

    public FileInfo(File file) {
        this.file = file;
        this.isDirectory = file.isDirectory();
        this.fileSize = file.length();
        this.path = file.getAbsolutePath();
        this.name = file.getName();
        this.lastModified = file.lastModified();
    }

    public String getFileInfoString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.isDirectory ? "[D] " : "[F] ").append("\t\t\t").append(this.fileSize).append("\t\t\t").append("lastModified ").append(DateUtils.gatDateTime(this.lastModified)).append("\t\t\t").append(this.name).append("\t\t\t").append(this.path).append('\n');
        return sb.toString();
    }

    public String getFileInfoString(FileInfo prevFi) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.isDirectory ? "[D] " : "[F] ").append("\t\t\t").append(this.fileSize);
        sb.append("\t\t\t").append("lastModified ").append(DateUtils.gatDateTime(this.lastModified));
        if (prevFi != null && this.isDirectory == prevFi.isDirectory && this.fileSize == prevFi.fileSize) {
            sb.append("!s");
        }
        if (prevFi != null && this.isDirectory == prevFi.isDirectory && this.fileSize == prevFi.fileSize && this.lastModified == prevFi.lastModified) {
            sb.append("!a");
        }
        if (prevFi != null && this.isDirectory == prevFi.isDirectory && this.name.equals(prevFi.name)) {
            sb.append("!n");
        }
        sb.append("\t\t\t").append(this.name).append("\t\t\t").append(this.path).append('\n');
        return sb.toString();
    }

    private String getFileDateAttributes() throws IOException {
        Path path = Paths.get(this.file.getAbsolutePath(), new String[0]);
        BasicFileAttributes atr = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
        StringBuilder sb = new StringBuilder();
        sb.append("atr lastModifiedTime ").append(atr.lastModifiedTime().toMillis()).append("\t\t\t").append("atr lastAccessTime ").append(atr.lastAccessTime().toMillis()).append("\t\t\t").append("atr creationTime ").append(atr.creationTime().toMillis());
        return sb.toString();
    }
}

