/*
 * Decompiled with CFR 0.152.
 */
package aljx.java.util.file;

import aljx.java.util.debug.Tracer;
import aljx.java.util.file.FileSearcher;
import aljx.java.util.file.filter.FileFilterSet;
import aljx.java.util.file.filter.FileSetFilter;
import aljx.java.util.file.filter.IsDirectory;
import aljx.java.util.file.filter.IsEmptyDirectory;
import aljx.java.util.file.filter.IsFile;
import aljx.java.util.file.zip.ZipEntryFile;
import aljx.java.util.file.zip.ZipHelper;
import aljx.java.util.file.zip.filter.ZipEntryFilter;
import aljx.java.util.stream.StreamReader;
import aljx.java.util.text.TextUtils;
import aljx.java.util.text.filter.StringFilter;
import aljx.java.util.text.modify.StringModifier;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Stack;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class FileHelper {
    private static final boolean PRINT_LOG = false;

    public static boolean isFileExist(String fileName) {
        File file = new File(fileName);
        return file.exists();
    }

    public static boolean createDirectory(File parent, String child) {
        return FileHelper.createDirectory(new File(parent, child));
    }

    public static boolean createDirectory(File dir) {
        return !dir.isDirectory() && dir.mkdir();
    }

    public static boolean createFile(File parent, String child) {
        return FileHelper.createFile(new File(parent, child));
    }

    public static boolean createFile(File file) {
        if (!file.isFile()) {
            try {
                file.createNewFile();
                return true;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    public static boolean createFile(String fileName) throws IOException {
        File f = new File(fileName);
        return f.createNewFile();
    }

    public static void deleteFile(File checkingFile, FileFilter filter) {
        if (filter.accept(checkingFile)) {
            checkingFile.delete();
        }
    }

    public static File newFileName(File file, String name) {
        return new File(file.getParent(), name);
    }

    public static File newFileName(File file, String target, String replacement) {
        return FileHelper.newFileName(file, file.getName().replace(target, replacement));
    }

    public static boolean rename(File file, String name) {
        return FileHelper.rename(file, name, false);
    }

    public static boolean rename(File file, String name, boolean deleteTarget) {
        File newFileName = FileHelper.newFileName(file, name);
        if (deleteTarget && newFileName.exists()) {
            newFileName.delete();
        }
        return file.renameTo(newFileName);
    }

    public static boolean rename(File file, String target, String replacement) {
        File newFileName = FileHelper.newFileName(file, target, replacement);
        return file.renameTo(newFileName);
    }

    public static boolean renameDirectory(File parent, String source, String destination) {
        return FileHelper.renameDirectory(new File(parent, source), new File(parent, destination));
    }

    public static boolean renameDirectory(File source, File destination) {
        return source.isDirectory() && source.renameTo(destination);
    }

    public static File renameDirectorySegment(File file, String parentDirName, int parentDirLevel, boolean createDirs) {
        if (parentDirLevel < 0) {
            throw new IllegalArgumentException();
        }
        File topLevelDir = null;
        topLevelDir = file.isDirectory() ? file : file.getParentFile();
        File dirForRename = topLevelDir;
        Stack<String> stack = new Stack<String>();
        for (int i = 0; i < parentDirLevel; ++i) {
            stack.push(dirForRename.getName());
            dirForRename = dirForRename.getParentFile();
        }
        File dirRenamed = FileHelper.newFileName(dirForRename, parentDirName);
        if (!(!createDirs || dirRenamed.exists() && dirRenamed.isDirectory())) {
            dirRenamed.mkdir();
        }
        while (!stack.isEmpty()) {
            String dirSegName = (String)stack.pop();
            dirRenamed = new File(dirRenamed, dirSegName);
            if (!createDirs) continue;
            dirRenamed.mkdir();
        }
        return dirRenamed;
    }

    public static void findAndReplaceDirectoryName(File srcDir, String regex, String replacement) {
        if (srcDir.isDirectory()) {
            String[] oChildren = srcDir.list();
            for (int i = 0; i < oChildren.length; ++i) {
                File subDir = new File(srcDir, oChildren[i]);
                FileHelper.findAndReplaceDirectoryName(subDir, regex, replacement);
                FileHelper.replaceDirectoryName(subDir, regex, replacement);
            }
        }
    }

    private static void replaceDirectoryName(File srcDir, String regex, String replacement) {
        String path = srcDir.getAbsolutePath();
        String newPath = path.replaceAll(regex, replacement);
        if (!newPath.equals(path)) {
            srcDir.renameTo(new File(newPath));
        }
    }

    public static void clearDirectory(File srcDir) throws IOException {
        FileHelper.clearDirectory(srcDir, null, null);
    }

    public static void clearDirectory(File srcDir, FileFilter findFilter, FileFilter deleteFilter) throws IOException {
        if (srcDir.isDirectory()) {
            ArrayList<File> childFilesList = new ArrayList<File>();
            File[] childFileArr = srcDir.listFiles();
            for (File file : childFileArr) {
                if (findFilter != null && !findFilter.accept(file)) continue;
                childFilesList.add(file);
            }
            for (File file : childFilesList) {
                if (file.isDirectory()) {
                    FileHelper.clearDirectory(file, findFilter, deleteFilter);
                }
                if (deleteFilter != null && !deleteFilter.accept(file)) continue;
                file.delete();
            }
        }
    }

    public static String readFile(String path) {
        File file = new File(path);
        return FileHelper.readFile(file);
    }

    public static String readFile(File file) {
        String result = "";
        try {
            result = StreamReader.streamToString(new FileInputStream(file));
        }
        catch (Exception e) {
            Tracer.e(e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile2(File fileForRead) throws IOException {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(fileForRead);
            FileChannel fc = stream.getChannel();
            MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
            String string = Charset.defaultCharset().decode(bb).toString();
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    public static List<String> readFileStrings(File file) {
        return FileHelper.readFileStrings(file, null);
    }

    public static List<String> readFileStrings(String path) {
        return FileHelper.readFileStrings(new File(path), null);
    }

    public static List<String> readFileStrings(String path, StringFilter stringFilter) {
        return FileHelper.readFileStrings(new File(path), stringFilter);
    }

    public static List<String> readFileStrings(File file, StringFilter stringFilter) {
        List<String> stringList = new ArrayList<String>();
        try {
            stringList = StreamReader.streamToStringList(new FileInputStream(file), stringFilter);
        }
        catch (IOException e) {
            Tracer.e(e);
        }
        return stringList;
    }

    public static void writeFileStrings(File targetFile, List<String> stringList) {
        FileHelper.createFile(targetFile);
        if (targetFile.exists()) {
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(targetFile));
                for (int i = 0; i < stringList.size() - 1; ++i) {
                    String line = stringList.get(i);
                    bufferedWriter.write(line);
                    bufferedWriter.newLine();
                }
                if (stringList.size() > 0) {
                    bufferedWriter.write(stringList.get(stringList.size() - 1));
                }
                bufferedWriter.close();
            }
            catch (IOException e) {
                Tracer.e(e);
            }
        }
    }

    public static void writeFileString(File targetFile, String line) {
        FileHelper.createFile(targetFile);
        if (targetFile.exists()) {
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(targetFile));
                bufferedWriter.write(line);
                bufferedWriter.flush();
                bufferedWriter.close();
            }
            catch (IOException e) {
                Tracer.e(e);
            }
        }
    }

    public static void writeValues(File targetFile, List<String> valuesList) {
        FileHelper.writeValues(targetFile, valuesList, null);
    }

    public static void writeValues(File targetFile, List<String> valuesList, String separator) {
        if (separator == null) {
            separator = ", ";
        }
        FileHelper.createFile(targetFile);
        if (targetFile.exists()) {
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(targetFile));
                for (int i = 0; i < valuesList.size() - 1; ++i) {
                    String line = valuesList.get(i);
                    bufferedWriter.write(line);
                    bufferedWriter.write(separator);
                }
                if (valuesList.size() > 0) {
                    bufferedWriter.write(valuesList.get(valuesList.size() - 1));
                }
                bufferedWriter.close();
            }
            catch (IOException e) {
                Tracer.e(e);
            }
        }
    }

    public static String[] list(File dir, FileFilter filter) {
        ArrayList<String> list = new ArrayList<String>();
        File[] fileArr = dir.listFiles(filter);
        if (fileArr != null) {
            for (File f : fileArr) {
                list.add(f.getName());
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public static void copyDirectory(File sourceLocation, File targetLocation) throws IOException {
        FileHelper.copyDirectory(sourceLocation, targetLocation, null);
    }

    public static void copyDirectory(File sourceLocation, File targetLocation, FileFilter filter) throws IOException {
        if (sourceLocation.isDirectory()) {
            if (!targetLocation.exists()) {
                targetLocation.mkdir();
            }
            String[] children = filter == null ? sourceLocation.list() : FileHelper.list(sourceLocation, filter);
            for (int i = 0; i < children.length; ++i) {
                FileHelper.copyDirectory(new File(sourceLocation, children[i]), new File(targetLocation, children[i]), filter);
            }
        } else {
            FileHelper.copyFile(sourceLocation, targetLocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceLocation, File targetLocation) {
        if (sourceLocation.isDirectory()) {
            return;
        }
        if (targetLocation.exists()) {
            targetLocation.delete();
        }
        if (!targetLocation.exists()) {
            try {
                targetLocation.createNewFile();
            }
            catch (IOException e) {
                Tracer.e(e);
            }
            FileInputStream in = null;
            OutputStream out = null;
            try {
                in = new FileInputStream(sourceLocation);
                out = new FileOutputStream(targetLocation);
                byte[] buffer = new byte[1024];
                int length = 0;
                try {
                    while ((length = ((InputStream)in).read(buffer)) > 0) {
                        out.write(buffer, 0, length);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            finally {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException iOException) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public static void copyFiles(File[] sourceLocation, File targetLocation) {
        if (sourceLocation == null) {
            return;
        }
        for (File file : sourceLocation) {
            FileHelper.copyFile(file, targetLocation);
        }
    }

    public static void zip(File source, File targetLocation) throws IOException {
        FileHelper.zipFiles(new File[]{source}, targetLocation, null);
    }

    public static void zip(File source, File targetLocation, FileFilter findFilter) throws IOException {
        FileHelper.zipFiles(new File[]{source}, targetLocation, findFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipFiles(File[] sourceLocation, File targetLocation, FileFilter findFilter) throws IOException {
        if (targetLocation.exists()) {
            targetLocation.delete();
        }
        if (targetLocation.exists()) {
            throw new IOException("Filed delete " + targetLocation);
        }
        boolean result = targetLocation.createNewFile();
        if (!result) {
            throw new IOException("File already exists!");
        }
        FileSearcher fileSearcher = new FileSearcher();
        ArrayList<ZipEntryFile> zipEntryFileList = new ArrayList<ZipEntryFile>();
        for (File f : sourceLocation) {
            if (f.isDirectory()) {
                fileSearcher.clear();
                fileSearcher.findFiles(f, findFilter, new FileFilterSet(true, new FileFilter[]{FileSetFilter.excludeInstance(targetLocation, f), new FileFilterSet(new FileFilter[]{new IsFile(), new IsEmptyDirectory()})}));
                ArrayList<File> fileList = fileSearcher.getFileList();
                ArrayList<String> dependedFileNameList = FileSearcher.getDependedFileNameList(fileList, f);
                for (int i = 0; i < fileList.size(); ++i) {
                    zipEntryFileList.add(new ZipEntryFile(fileList.get(i), dependedFileNameList.get(i)));
                }
                continue;
            }
            zipEntryFileList.add(new ZipEntryFile(f, f.getName()));
        }
        ZipHelper.fixEntryList(zipEntryFileList);
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(targetLocation)));
            for (ZipEntryFile zipEntryFile : zipEntryFileList) {
                ZipEntry entry;
                if (zipEntryFile.file.isDirectory()) {
                    entry = new ZipEntry(zipEntryFile.getEntryName() + File.separator);
                    zos.putNextEntry(entry);
                    zos.closeEntry();
                    continue;
                }
                if (!zipEntryFile.file.isFile()) continue;
                entry = new ZipEntry(zipEntryFile.getEntryName());
                zos.putNextEntry(entry);
                FileInputStream in = new FileInputStream(zipEntryFile.file);
                byte[] buffer = new byte[1024];
                int length = 0;
                while ((length = in.read(buffer)) > 0) {
                    zos.write(buffer, 0, length);
                }
                in.close();
                zos.closeEntry();
            }
        }
        finally {
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void unzip(File zipFile, File outDir) throws IOException {
        FileHelper.unzip(zipFile, outDir, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File zipFile, File outDir, ZipEntryFilter filter) throws IOException {
        if (outDir.exists()) {
            if (!outDir.isDirectory()) {
                outDir.delete();
                outDir.mkdir();
            }
        } else {
            outDir.mkdir();
        }
        if (!outDir.isDirectory()) {
            throw new IllegalStateException("Failed prepare dir");
        }
        ZipInputStream zin = null;
        try {
            ZipEntry entry;
            zin = new ZipInputStream(new FileInputStream(zipFile));
            while ((entry = zin.getNextEntry()) != null) {
                if (filter != null && !filter.accept(entry)) continue;
                String name = entry.getName();
                if (ZipHelper.isDirectory(entry)) {
                    FileHelper.mkdirs(outDir, name);
                    continue;
                }
                String dir = ZipHelper.getDirectory(entry);
                if (!TextUtils.isEmpty(dir)) {
                    FileHelper.mkdirs(outDir, dir);
                }
                StreamReader.CloseControl.streamToFile(zin, new File(outDir, name), false);
            }
        }
        finally {
            if (zin != null) {
                try {
                    zin.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void packJar(File sourceDir, File destinationFile) throws IOException {
        FileHelper.packJar(sourceDir, destinationFile, null, null);
    }

    public static void packJar(File sourceDir, File destinationFile, String version) throws IOException {
        FileHelper.packJar(sourceDir, destinationFile, version, null);
    }

    public static void packJar(File sourceDir, File destinationFile, String version, String mainClass) throws IOException {
        destinationFile.delete();
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        if (!TextUtils.isEmpty(version)) {
            manifest.getMainAttributes().put(Attributes.Name.IMPLEMENTATION_VERSION, version);
        }
        if (!TextUtils.isEmpty(mainClass)) {
            manifest.getMainAttributes().put(Attributes.Name.MAIN_CLASS, mainClass);
        }
        JarOutputStream target = new JarOutputStream((OutputStream)new FileOutputStream(destinationFile), manifest);
        String topDir = sourceDir.getPath().replace("\\", "/");
        if (!TextUtils.isEmpty(topDir) && !topDir.endsWith("/")) {
            topDir = topDir + "/";
        }
        FileHelper.addToJar(topDir.length(), sourceDir, target);
        target.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addToJar(int jarDirsStartIndex, File source, JarOutputStream target) throws IOException {
        BufferedInputStream in = null;
        try {
            int count;
            if (source.isDirectory()) {
                String name = source.getPath().replace("\\", "/");
                if (!name.isEmpty() && name.length() > jarDirsStartIndex) {
                    if (!name.endsWith("/")) {
                        name = name + "/";
                    }
                    name = name.substring(jarDirsStartIndex);
                    JarEntry entry = new JarEntry(name);
                    entry.setTime(source.lastModified());
                    target.putNextEntry(entry);
                    target.closeEntry();
                }
                for (File nestedFile : source.listFiles()) {
                    FileHelper.addToJar(jarDirsStartIndex, nestedFile, target);
                }
                return;
            }
            String name = source.getPath().replace("\\", "/").substring(jarDirsStartIndex);
            JarEntry entry = new JarEntry(name);
            entry.setTime(source.lastModified());
            target.putNextEntry(entry);
            in = new BufferedInputStream(new FileInputStream(source));
            byte[] buffer = new byte[1024];
            while ((count = in.read(buffer)) != -1) {
                target.write(buffer, 0, count);
            }
            target.closeEntry();
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static void unpackJar(String source, String destinationDir) throws IOException {
        FileHelper.unpackJar(new File(source), new File(destinationDir));
    }

    public static void unpackJar(File source, File destinationDir) throws IOException {
        destinationDir.mkdir();
        JarFile jarFile = new JarFile(source);
        Enumeration<JarEntry> jarEntryEnumeration = jarFile.entries();
        while (jarEntryEnumeration.hasMoreElements()) {
            JarEntry jarEntry = jarEntryEnumeration.nextElement();
            File file = new File(destinationDir, jarEntry.getName());
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file = new File(destinationDir, jarEntry.getName());
            }
            if (jarEntry.isDirectory()) continue;
            InputStream is = jarFile.getInputStream(jarEntry);
            FileOutputStream fo = new FileOutputStream(file);
            while (is.available() > 0) {
                fo.write(is.read());
            }
            fo.close();
            is.close();
        }
    }

    private static boolean mkdirs(File outDir, String path) {
        File d = new File(outDir, path);
        if (!d.exists()) {
            return d.mkdirs();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replaceFileStr(File fileForReplace, String regex, String replacement) throws IOException {
        String fileContent = FileHelper.readFile(fileForReplace);
        fileContent = fileContent.replaceAll(regex, replacement);
        FileWriter os = new FileWriter(fileForReplace);
        try {
            os.write(fileContent);
            os.flush();
        }
        finally {
            os.close();
        }
    }

    public static void replaceFilesContent(File targetFile, String regex, String replacement, FileFilter filter) {
        if (targetFile.isDirectory()) {
            File[] files = targetFile.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (!filter.accept(file)) continue;
                FileHelper.replaceFilesContent(file, regex, replacement, filter);
            }
        } else {
            try {
                FileHelper.replaceFileStr(targetFile, regex, replacement);
            }
            catch (IOException e) {
                Tracer.e(e);
            }
        }
    }

    public static boolean isExist(File file) {
        String[] list;
        boolean exist = false;
        File parentFile = file.getParentFile();
        if (parentFile != null && (list = parentFile.list()) != null) {
            List<String> fileList = Arrays.asList(list);
            String name = file.getName();
            exist = fileList.contains(name);
        }
        return exist;
    }

    public static boolean isExist(String path) {
        return FileHelper.isExist(new File(path));
    }

    public static void modifyFileContent(String inputFilePath, String outputFilePath, StringModifier stringModifier) {
        File inputFile = new File(inputFilePath);
        File outputFile = new File(outputFilePath);
        FileHelper.modifyFileContent(inputFile, outputFile, stringModifier);
    }

    public static void modifyFileContent(File inputFile, File outputFile, StringModifier stringModifier) {
        FileHelper.createFile(inputFile);
        FileHelper.createFile(outputFile);
        String text = FileHelper.readFile(inputFile);
        String modifiedText = stringModifier.modify(text);
        FileHelper.writeFileString(outputFile, modifiedText);
    }

    public static void copyFileContent(String inputFilePath, String outputFilePath, StringFilter stringFilter) {
        File inputFile = new File(inputFilePath);
        File outputFile = new File(outputFilePath);
        FileHelper.copyFileContent(inputFile, outputFile, stringFilter);
    }

    public static void copyFileContent(File inputFile, File outputFile, StringFilter stringFilter) {
        FileHelper.createFile(inputFile);
        List<String> filteredStrings = FileHelper.readFileStrings(inputFile, stringFilter);
        FileHelper.writeFileStrings(outputFile, filteredStrings);
    }

    public static File goDeeper(File releaseSourcePath, int levelCount) {
        if (levelCount < 1) {
            throw new IllegalArgumentException("level = " + levelCount);
        }
        File dir = releaseSourcePath;
        for (int curLevel = 0; curLevel < levelCount; ++curLevel) {
            File[] files = dir.listFiles(new IsDirectory());
            if (files == null || files.length == 0) {
                throw new IllegalStateException("Filed go to level " + curLevel + " in " + releaseSourcePath.getAbsolutePath() + " cur dir = " + dir);
            }
            dir = files[0];
        }
        return dir;
    }

    public static File getCurrentDir() {
        String property = System.getProperty("user.dir");
        return TextUtils.isEmpty(property) ? new File("1.txt").getParentFile() : new File(property);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveToFile(byte[] bytes, File file) {
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(file);
            stream.write(bytes);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                stream.close();
            }
            catch (Exception exception) {}
        }
    }
}

