/*
 * Decompiled with CFR 0.152.
 */
package aljx.java.util.builder;

import aljx.java.util.debug.Tracer;
import aljx.java.util.file.FileHelper;
import aljx.java.util.file.FileSearcher;
import aljx.java.util.file.filter.FileFilterSet;
import aljx.java.util.file.filter.FileName;
import aljx.java.util.file.filter.FileType;
import aljx.java.util.file.filter.IsEmptyDirectory;
import aljx.java.util.file.filter.IsFile;
import aljx.java.util.file.zip.filter.RootZippedFileEntryFilter;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;

public class BuildHelper {
    public static void getAarJars(File aarLibsDir) {
        FileSearcher fileSearcher = new FileSearcher();
        fileSearcher.findFiles(aarLibsDir, new IsFile(), new FileType(".aar"));
        ArrayList<File> aarLibs = fileSearcher.getFileList();
        for (File aar : aarLibs) {
            try {
                FileHelper.unzip(aar, aarLibsDir, new RootZippedFileEntryFilter("classes.jar"));
            }
            catch (IOException e) {
                Tracer.e(e);
            }
            FileHelper.rename(new File(aarLibsDir, "classes.jar"), aar.getName().replace(".aar", ".jar"), true);
        }
    }

    public static void clearArr(File aarLibsDir) {
        FileSearcher fileSearcher = new FileSearcher();
        fileSearcher.findFiles(aarLibsDir, new IsFile(), new FileType(".aar"));
        ArrayList<File> aarLibs = fileSearcher.getFileList();
        for (File aar : aarLibs) {
            aar.delete();
        }
    }

    public static void getPublishZip(File buildDir, File releaseSourcePath, String version) {
        try {
            FileHelper.zip(releaseSourcePath, new File(buildDir, releaseSourcePath.getName() + "_" + version + ".zip"), FileName.excludeFileInstance("maven-metadata.xml", "maven-metadata.xml.md5", "maven-metadata.xml.sha1"));
        }
        catch (IOException e) {
            Tracer.e(e);
        }
    }

    public static void joinJars(ArrayList<File> jars, File outputDir, String name, String version) {
        File unpackedDir = new File(outputDir, name);
        try {
            FileHelper.clearDirectory(unpackedDir);
        }
        catch (IOException e) {
            Tracer.e(e);
        }
        for (File jar : jars) {
            try {
                FileHelper.unpackJar(jar, unpackedDir);
            }
            catch (IOException e) {
                Tracer.e(e);
            }
        }
        try {
            FileHelper.clearDirectory(unpackedDir, null, new FileFilterSet(new FileFilter[]{new FileName("MANIFEST.MF", "BuildConfig.class", "BuildConfig.java"), new IsEmptyDirectory()}));
        }
        catch (IOException e) {
            Tracer.e(e);
        }
        File destinationFile = new File(outputDir, name + ".jar");
        try {
            FileHelper.packJar(unpackedDir, destinationFile, version);
        }
        catch (IOException e) {
            Tracer.e(e);
        }
    }
}

