/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.timing;

import ai.libs.jaicore.basic.IObjectEvaluator;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmTimeoutedException;
import ai.libs.jaicore.basic.algorithm.exceptions.ObjectEvaluationFailedException;
import ai.libs.jaicore.timing.TimedComputation;
import java.util.concurrent.ExecutionException;

public abstract class TimedObjectEvaluator<T, V extends Comparable<V>>
implements IObjectEvaluator<T, V> {
    public abstract V evaluateSupervised(T var1) throws InterruptedException, ObjectEvaluationFailedException;

    public abstract long getTimeout(T var1);

    public abstract String getMessage(T var1);

    @Override
    public final V evaluate(T object) throws InterruptedException, ObjectEvaluationFailedException {
        try {
            return (V)TimedComputation.compute(() -> this.evaluateSupervised(object), this.getTimeout(object), this.getMessage(object));
        }
        catch (InterruptedException e) {
            assert (!Thread.currentThread().isInterrupted()) : "The interrupt-flag should not be true when an InterruptedException is thrown! Stack trace of the InterruptedException is \n\t";
            throw e;
        }
        catch (AlgorithmTimeoutedException e) {
            throw new ObjectEvaluationFailedException("Timed object evaluation failed", e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ObjectEvaluationFailedException) {
                throw (ObjectEvaluationFailedException)e.getCause();
            }
            throw new ObjectEvaluationFailedException("Evaluation of composition failed as the component instantiation could not be built.", e.getCause());
        }
    }
}

