/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.logging;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Collection;
import java.util.Map;

public class ToJSONStringUtil {
    private ToJSONStringUtil() {
    }

    public static String toJSONString(Map<String, Object> fields) {
        ObjectMapper om = new ObjectMapper();
        ObjectNode root = om.createObjectNode();
        for (Map.Entry<String, Object> field : fields.entrySet()) {
            root.set(field.getKey(), ToJSONStringUtil.parseObjectToJsonNode(field.getValue(), om));
        }
        try {
            return om.writeValueAsString((Object)root);
        }
        catch (JsonProcessingException e) {
            return "JSON representation of toString could not be generated.";
        }
    }

    public static String toJSONString(String rootName, Map<String, Object> fields) {
        ObjectMapper om = new ObjectMapper();
        ObjectNode root = om.createObjectNode();
        ObjectNode innerObject = om.createObjectNode();
        root.set(rootName, (JsonNode)innerObject);
        for (Map.Entry<String, Object> field : fields.entrySet()) {
            innerObject.set(field.getKey(), ToJSONStringUtil.parseObjectToJsonNode(field.getValue(), om));
        }
        try {
            return om.writeValueAsString((Object)root);
        }
        catch (JsonProcessingException e) {
            return rootName + " JSON representation of toString could not be generated.";
        }
    }

    public static JsonNode parseObjectToJsonNode(Object fieldValue, ObjectMapper om) {
        if (fieldValue == null) {
            return new TextNode(fieldValue + "");
        }
        if (fieldValue instanceof JsonNode) {
            return (JsonNode)fieldValue;
        }
        if (fieldValue instanceof Collection) {
            ArrayNode valueArray = om.createArrayNode();
            for (Object value : (Collection)fieldValue) {
                valueArray.add(ToJSONStringUtil.parseObjectToJsonNode(value, om));
            }
            return valueArray;
        }
        if (fieldValue.getClass().isArray()) {
            ArrayNode valueArray = om.createArrayNode();
            for (Object value : (Object[])fieldValue) {
                valueArray.add(ToJSONStringUtil.parseObjectToJsonNode(value, om));
            }
            return valueArray;
        }
        if (fieldValue instanceof Map) {
            ObjectNode valueMap = om.createObjectNode();
            for (Map.Entry entry : ((Map)fieldValue).entrySet()) {
                valueMap.set(entry.getKey() + "", ToJSONStringUtil.parseObjectToJsonNode(entry.getValue(), om));
            }
            return valueMap;
        }
        try {
            return om.readTree(fieldValue + "");
        }
        catch (Exception e) {
            return new TextNode(fieldValue + "");
        }
    }
}

