/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic.sets;

import ai.libs.jaicore.basic.sets.PartialOrderedSet;
import java.util.LinkedList;
import java.util.List;

public class PartialOrderedSetUtil {
    private final PartialOrderedSet<Integer> set;

    public PartialOrderedSetUtil(PartialOrderedSet<Integer> set) {
        this.set = set;
    }

    public int calc() {
        if (this.set.isEmpty()) {
            return 0;
        }
        if (this.set.size() == 1) {
            return 1;
        }
        LinkedList<Integer> list = new LinkedList<Integer>(this.set);
        return this.getNumberOfAllowedPermutations(new LinkedList<Integer>(), list);
    }

    private int getNumberOfAllowedPermutations(List<Integer> prefix, List<Integer> suffix) {
        if (suffix.isEmpty()) {
            return this.isCompatible(prefix) ? 1 : 0;
        }
        int numberOfCompatiblePermutations = 0;
        for (int i = 0; i < suffix.size(); ++i) {
            LinkedList<Integer> newPrefix = new LinkedList<Integer>(prefix);
            newPrefix.add(suffix.get(i));
        }
        return numberOfCompatiblePermutations;
    }

    private boolean isCompatible(List<Integer> totalOrder) {
        for (int i = 0; i < totalOrder.size() - 1; ++i) {
            for (int j = i + 1; j < totalOrder.size(); ++j) {
                if (this.set.allowsABeforeB(totalOrder.get(i), totalOrder.get(j))) continue;
                return false;
            }
        }
        return true;
    }
}

