/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic.kvstore;

import ai.libs.jaicore.basic.FileUtil;
import ai.libs.jaicore.basic.Maps;
import ai.libs.jaicore.basic.StatisticsUtil;
import ai.libs.jaicore.basic.kvstore.IKVFilter;
import ai.libs.jaicore.basic.kvstore.KVStore;
import ai.libs.jaicore.basic.sets.SetUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KVStoreCollection
extends LinkedList<KVStore> {
    private static final Logger logger = LoggerFactory.getLogger(KVStoreCollection.class);
    private static final long serialVersionUID = -4198481782449606136L;
    private static final String LABEL_GROUP_SIZE = "GROUP_SIZE";
    private static final EGroupMethod STANDARD_GROUPING_HANDLER = EGroupMethod.LIST;
    private static final String FIELD_COLLECTIONID = "collectionID";
    private final KVStore metaData = new KVStore();

    public KVStoreCollection() {
    }

    public KVStoreCollection(String taskChunkDescription) {
        this.readFrom(taskChunkDescription);
    }

    public KVStoreCollection(KVStoreCollection other) {
        this.addAll(other);
    }

    public KVStoreCollection(File file) {
        if (file.isDirectory()) {
            this.setCollectionID(file.getName());
            for (File subFile : file.listFiles()) {
                if (subFile.isFile()) {
                    try (BufferedReader br = new BufferedReader(new FileReader(subFile));){
                        String line;
                        while ((line = br.readLine()) != null) {
                            KVStore kvStore = new KVStore(line);
                            kvStore.setCollection(this);
                            this.add(kvStore);
                        }
                    }
                    catch (Exception e) {
                        logger.error("An exception occurred while parsing the directory collecting the chunk: {}", (Throwable)e);
                    }
                    continue;
                }
                try {
                    this.readFrom(FileUtil.readFileAsString(file));
                }
                catch (Exception e) {
                    logger.error("An exception occurred while reading the chunk from the given file: {}", (Throwable)e);
                }
            }
        }
    }

    public KVStoreCollection select(Map<String, String> selection) {
        KVStoreCollection selectedCollection = new KVStoreCollection();
        for (KVStore store : this) {
            if (!store.matches(selection)) continue;
            selectedCollection.add(store);
        }
        return selectedCollection;
    }

    public KVStoreCollection filter(String[] filterKeys) {
        KVStoreCollection filteredCollection = new KVStoreCollection();
        for (KVStore store : this) {
            store.project(filterKeys);
            filteredCollection.add(store);
        }
        return filteredCollection;
    }

    public void readFrom(String chunkDescription) {
        String[] lines = chunkDescription.split("\n");
        if (lines.length < 1) {
            throw new IllegalArgumentException("Invalid format of chunk description");
        }
        boolean first = true;
        for (String line : lines) {
            if (line.trim().equals("") || line.trim().startsWith("#")) continue;
            if (first) {
                first = false;
                this.metaData.readKVStoreFromDescription(line);
                continue;
            }
            KVStore task = new KVStore(line);
            task.setCollection(this);
            this.add(task);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.metaData.toString() + "\n");
        for (KVStore t : this) {
            sb.append(t.toString() + "\n");
        }
        return sb.toString();
    }

    public void removeAny(String value) {
        this.removeAny(new String[]{value}, true);
    }

    public void removeAny(String[] value, boolean or) {
        LinkedList<KVStore> tasksToRemove = new LinkedList<KVStore>();
        block0: for (KVStore t : this) {
            if (or) {
                for (String v : value) {
                    if (!t.toString().contains(v)) continue;
                    tasksToRemove.add(t);
                    continue block0;
                }
                continue;
            }
            throw new UnsupportedOperationException("Not yet implemented");
        }
        this.removeAll(tasksToRemove);
    }

    public void removeAny(Map<String, String> condition, boolean or) {
        if (or) {
            this.removeIf(t -> {
                for (Map.Entry entry : condition.entrySet()) {
                    String val = t.getAsString((String)entry.getKey());
                    if ((val != null || entry.getValue() != null) && (val == null || !val.equals(entry.getValue()))) continue;
                    return true;
                }
                return false;
            });
        } else {
            this.removeIf(t -> {
                for (Map.Entry entry : condition.entrySet()) {
                    if (t.getAsString((String)entry.getKey()).equals(entry.getValue())) continue;
                    return false;
                }
                return true;
            });
        }
    }

    public void removeGroupsIfNotAtLeastWithSize(int size) {
        HashMap<String, String> groupSizeCondition = new HashMap<String, String>();
        for (int i = 1; i < size; ++i) {
            groupSizeCondition.put(LABEL_GROUP_SIZE, "" + i);
            this.removeAny(groupSizeCondition, true);
        }
    }

    public void removeGroupsIfNotAtLeastWithSizeButOne(int size, String[] groupingKeys) {
        HashMap<String, String> groupSizeCondition = new HashMap<String, String>();
        for (int i = 1; i < size; ++i) {
            logger.debug("Remove any groups that dont have at least {} entries.", (Object)(i + 1));
            int currentMinLength = i;
            KVStoreCollection group = new KVStoreCollection(this.toString());
            group.renameKey(LABEL_GROUP_SIZE, "size");
            group = group.group(groupingKeys, new HashMap<String, EGroupMethod>());
            for (KVStore t : group) {
                List sizeList = t.getAsIntList("size", ",").stream().filter(x -> x > currentMinLength).collect(Collectors.toList());
                logger.debug("{} {} {}", new Object[]{currentMinLength, sizeList, t.getAsIntList("size", ",")});
                if (sizeList.size() <= 0) continue;
                for (String groupingKey : groupingKeys) {
                    groupSizeCondition.put(groupingKey, t.getAsString(groupingKey));
                }
                groupSizeCondition.put(LABEL_GROUP_SIZE, "" + i);
                logger.debug("{}", groupSizeCondition);
                this.removeAny(groupSizeCondition, false);
            }
        }
    }

    public void renameKey(String keyName, String newKeyName) {
        for (KVStore t : this) {
            t.renameKey(keyName, newKeyName);
        }
    }

    public KVStoreCollection group(String[] groupingKeys, Map<String, EGroupMethod> groupingHandler) {
        KVStoreCollection tempCollection = new KVStoreCollection();
        tempCollection.setCollectionID(this.getCollectionID());
        HashMap<String, LinkedList<KVStore>> groupedTasks = new HashMap<String, LinkedList<KVStore>>();
        for (KVStore kVStore : this) {
            StringBuilder sb = new StringBuilder();
            for (String string : groupingKeys) {
                sb.append(kVStore.getAsString(string) + "#");
            }
            LinkedList<KVStore> groupedTaskList = (LinkedList<KVStore>)groupedTasks.get(sb.toString());
            if (groupedTaskList == null) {
                groupedTaskList = new LinkedList<KVStore>();
                groupedTasks.put(sb.toString(), groupedTaskList);
            }
            groupedTaskList.add(kVStore);
        }
        for (Map.Entry entry : groupedTasks.entrySet()) {
            List groupedTaskList = (List)entry.getValue();
            KVStore groupedTask = new KVStore((KVStore)groupedTaskList.get(0));
            groupedTask.put(LABEL_GROUP_SIZE, groupedTaskList.size());
            HashMap values = new HashMap();
            for (KVStore kVStore : groupedTaskList) {
                for (Map.Entry e : kVStore.entrySet()) {
                    boolean containedInGrouping = false;
                    for (String groupingKey : groupingKeys) {
                        if (!groupingKey.equals(e.getKey())) continue;
                        containedInGrouping = true;
                        break;
                    }
                    if (containedInGrouping) continue;
                    LinkedList objectList = (LinkedList)values.get(e.getKey());
                    if (objectList == null) {
                        objectList = new LinkedList();
                        values.put(e.getKey(), objectList);
                    }
                    objectList.add(e.getValue());
                }
            }
            for (Map.Entry entry2 : values.entrySet()) {
                EGroupMethod groupingMethod = groupingHandler.get(entry2.getKey());
                if (groupingMethod == null) {
                    groupingMethod = STANDARD_GROUPING_HANDLER;
                }
                Object value = null;
                switch (groupingMethod) {
                    case AVG: {
                        List valueList = ((List)entry2.getValue()).stream().map(x -> Double.valueOf(x.toString())).collect(Collectors.toList());
                        groupedTask.put((String)entry2.getKey() + "_stdDev", StatisticsUtil.standardDeviation(valueList));
                        groupedTask.put((String)entry2.getKey() + "_max", StatisticsUtil.max(valueList));
                        groupedTask.put((String)entry2.getKey() + "_min", StatisticsUtil.min(valueList));
                        groupedTask.put((String)entry2.getKey() + "_var", StatisticsUtil.variance(valueList));
                        groupedTask.put((String)entry2.getKey() + "_sum", StatisticsUtil.sum(valueList));
                        groupedTask.put((String)entry2.getKey() + "_list", SetUtil.implode(valueList, ","));
                        value = StatisticsUtil.mean(valueList);
                        break;
                    }
                    case MIN: {
                        value = StatisticsUtil.min(((List)entry2.getValue()).stream().map(x -> Double.valueOf(x.toString())).collect(Collectors.toList()));
                        break;
                    }
                    case MAX: {
                        value = StatisticsUtil.max(((List)entry2.getValue()).stream().map(x -> Double.valueOf(x.toString())).collect(Collectors.toList()));
                        break;
                    }
                    case MINORITY: {
                        value = this.frequentObject((List)entry2.getValue(), false);
                        break;
                    }
                    case MAJORITY: {
                        value = this.frequentObject((List)entry2.getValue(), true);
                        break;
                    }
                    case ADD: {
                        value = StatisticsUtil.sum(((List)entry2.getValue()).stream().map(x -> Double.valueOf(x.toString())).collect(Collectors.toList()));
                        break;
                    }
                    default: {
                        value = SetUtil.implode((Collection)entry2.getValue(), ",");
                    }
                }
                groupedTask.put(entry2.getKey(), value);
            }
            tempCollection.add(groupedTask);
        }
        return new KVStoreCollection(tempCollection.toString());
    }

    private Object frequentObject(List<Object> listOfObjects, boolean top) {
        HashMap counterMap = new HashMap();
        for (Object v : listOfObjects) {
            Maps.increaseCounterInMap(counterMap, v);
        }
        Object frequentObject = null;
        for (Map.Entry counterMapEntry : counterMap.entrySet()) {
            if (frequentObject != null && (!top || (Integer)counterMap.get(counterMapEntry.getKey()) <= (Integer)counterMap.get(frequentObject)) && (top || (Integer)counterMap.get(counterMapEntry.getKey()) >= (Integer)counterMap.get(frequentObject))) continue;
            frequentObject = counterMapEntry.getKey();
        }
        return frequentObject;
    }

    public void merge(String[] fieldKeys, String separator, String newFieldName) {
        for (KVStore t : this) {
            t.merge(fieldKeys, separator, newFieldName);
        }
    }

    public void project(String[] keepKeys) {
        this.metaData.project(keepKeys);
        for (KVStore t : this) {
            t.project(keepKeys);
        }
    }

    public void projectRemove(String ... removeKeys) {
        this.metaData.removeAll(removeKeys);
        for (KVStore t : this) {
            t.removeAll(removeKeys);
        }
    }

    public void applyFilter(Map<String, IKVFilter> filterMap) {
        this.metaData.filter(filterMap);
        for (KVStore t : this) {
            t.filter(filterMap);
        }
    }

    public void applyFilter(String keyName, IKVFilter filter) {
        HashMap<String, IKVFilter> filterMap = new HashMap<String, IKVFilter>();
        filterMap.put(keyName, filter);
        this.applyFilter(filterMap);
    }

    public void mergeTasks(KVStore other, Map<String, String> combineMap) {
        for (KVStore t : this) {
            boolean equals = true;
            for (Map.Entry<String, String> combineEntry : combineMap.entrySet()) {
                if (t.containsKey(combineEntry.getKey()) && other.containsKey(combineEntry.getValue()) && t.getAsString(combineEntry.getKey()).equals(other.getAsString(combineEntry.getValue()))) continue;
                equals = false;
                break;
            }
            if (!equals) continue;
            t.putAll(other);
        }
    }

    public String getCollectionID() {
        return this.metaData.getAsString(FIELD_COLLECTIONID);
    }

    public void setCollectionID(String collectionID) {
        this.metaData.put(FIELD_COLLECTIONID, collectionID);
    }

    public void serializeTo(File file) throws IOException {
        this.serializeTo(file, false);
    }

    public void serializeTo(File file, boolean append) throws IOException {
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(file, append));){
            bw.write(this.toString());
        }
    }

    public KVStoreCollection group(String ... groupingKeys) {
        return this.group(groupingKeys, new HashMap<String, EGroupMethod>());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof KVStoreCollection)) {
            return false;
        }
        KVStoreCollection other = (KVStoreCollection)obj;
        if (new EqualsBuilder().append((Object)this.metaData, (Object)other.metaData).isEquals()) {
            return super.equals(other);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.metaData).append(super.hashCode()).toHashCode();
    }

    public static enum EGroupMethod {
        AVG,
        MIN,
        MAX,
        MAJORITY,
        MINORITY,
        LIST,
        ADD;


        public static EGroupMethod getStandardGroupingHandler() {
            return LIST;
        }
    }
}

