/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic.algorithm.reduction;

import ai.libs.jaicore.basic.ILoggingCustomizable;
import ai.libs.jaicore.basic.ScoredItem;
import ai.libs.jaicore.basic.TimeOut;
import ai.libs.jaicore.basic.algorithm.AOptimizer;
import ai.libs.jaicore.basic.algorithm.AlgorithmExecutionCanceledException;
import ai.libs.jaicore.basic.algorithm.IOptimizationAlgorithm;
import ai.libs.jaicore.basic.algorithm.IOptimizationAlgorithmFactory;
import ai.libs.jaicore.basic.algorithm.events.ASolutionCandidateFoundEvent;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmEvent;
import ai.libs.jaicore.basic.algorithm.events.SolutionCandidateFoundEvent;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmException;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmTimeoutedException;
import ai.libs.jaicore.basic.algorithm.reduction.AlgorithmicProblemReduction;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReducingOptimizer<I1, O1 extends ScoredItem<V>, I2, O2 extends ScoredItem<V>, V extends Comparable<V>>
extends AOptimizer<I1, O1, V> {
    private Logger logger = LoggerFactory.getLogger(ReducingOptimizer.class);
    private String loggerName;
    private final AlgorithmicProblemReduction<I1, O1, I2, O2> problemTransformer;
    private final IOptimizationAlgorithm<I2, O2, V> baseOptimizer;

    public ReducingOptimizer(I1 problem, AlgorithmicProblemReduction<I1, O1, I2, O2> problemTransformer, IOptimizationAlgorithmFactory<I2, O2, V> baseFactory) {
        super(problem);
        this.problemTransformer = problemTransformer;
        this.baseOptimizer = baseFactory.getAlgorithm((Object)problemTransformer.encodeProblem(problem));
    }

    @Override
    public final void cancel() {
        super.cancel();
        this.baseOptimizer.cancel();
    }

    public void runPreCreationHook() {
    }

    protected SolutionCandidateFoundEvent<O1> getSolutionEvent(O1 solution) {
        return new ASolutionCandidateFoundEvent<O1>(this.getId(), solution);
    }

    @Override
    public final AlgorithmEvent nextWithException() throws AlgorithmExecutionCanceledException, InterruptedException, AlgorithmTimeoutedException, AlgorithmException {
        if (this.isCanceled()) {
            throw new IllegalStateException("The algorithm has already been canceled. Cannot conduct fut\u00c5\u2022ther steps.");
        }
        switch (this.getState()) {
            case CREATED: {
                this.runPreCreationHook();
                TimeOut to = this.getTimeout();
                this.logger.debug("Setting timeout of search to {}", (Object)to);
                this.baseOptimizer.setTimeout(to);
                return this.activate();
            }
            case ACTIVE: {
                this.logger.info("Starting/continuing search for next plan.");
                try {
                    ScoredItem solution = (ScoredItem)this.baseOptimizer.nextSolutionCandidate();
                    if (solution == null) {
                        this.logger.info("No more solutions will be found. Terminating algorithm.");
                        return this.terminate();
                    }
                    this.logger.info("Next solution found.");
                    ScoredItem solutionToOriginalProlem = (ScoredItem)this.problemTransformer.decodeSolution(solution);
                    SolutionCandidateFoundEvent<ScoredItem> event = this.getSolutionEvent(solutionToOriginalProlem);
                    this.post(event);
                    return event;
                }
                catch (NoSuchElementException e) {
                    return this.terminate();
                }
            }
        }
        throw new IllegalStateException("Don't know what to do in state " + (Object)((Object)this.getState()));
    }

    @Override
    public String getLoggerName() {
        return this.loggerName;
    }

    @Override
    public void setLoggerName(String name) {
        this.logger.info("Switching logger from {} to {}", (Object)this.logger.getName(), (Object)name);
        this.loggerName = name;
        this.logger = LoggerFactory.getLogger((String)name);
        this.logger.info("Activated logger {} with name {}", (Object)name, (Object)this.logger.getName());
        if (this.problemTransformer instanceof ILoggingCustomizable) {
            this.logger.info("Setting logger of problem transformer to {}.problemtransformer", (Object)name);
            ((ILoggingCustomizable)((Object)this.problemTransformer)).setLoggerName(name + ".problemtransformer");
        }
        if (this.baseOptimizer instanceof ILoggingCustomizable) {
            this.logger.info("Setting logger of search to {}.base", (Object)name);
            ((ILoggingCustomizable)((Object)this.baseOptimizer)).setLoggerName(name + ".base");
        }
        super.setLoggerName(this.loggerName + "._algorithm");
    }

    protected Logger getLogger() {
        return this.logger;
    }

    public AlgorithmicProblemReduction<I1, O1, I2, O2> getProblemTransformer() {
        return this.problemTransformer;
    }

    public IOptimizationAlgorithm<I2, O2, V> getBaseOptimizer() {
        return this.baseOptimizer;
    }
}

