/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic.algorithm;

import ai.libs.jaicore.basic.ScoredItem;
import ai.libs.jaicore.basic.algorithm.ASolutionCandidateIterator;
import ai.libs.jaicore.basic.algorithm.AlgorithmExecutionCanceledException;
import ai.libs.jaicore.basic.algorithm.IAlgorithmConfig;
import ai.libs.jaicore.basic.algorithm.IOptimizationAlgorithm;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmEvent;
import ai.libs.jaicore.basic.algorithm.events.SolutionCandidateFoundEvent;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmException;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmTimeoutedException;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AOptimizer<I, O extends ScoredItem<V>, V extends Comparable<V>>
extends ASolutionCandidateIterator<I, O>
implements IOptimizationAlgorithm<I, O, V> {
    private Logger logger = LoggerFactory.getLogger(AOptimizer.class);
    private String loggerName;
    private O bestSeenSolution;

    public AOptimizer(I input) {
        super(input);
    }

    protected AOptimizer(IAlgorithmConfig config, I input) {
        super(config, input);
    }

    protected boolean updateBestSeenSolution(O candidate) {
        assert (candidate != null) : "Cannot update best solution with null.";
        if (this.bestSeenSolution == null || candidate.getScore() != null && candidate.getScore().compareTo(this.bestSeenSolution.getScore()) < 0) {
            this.bestSeenSolution = candidate;
            return true;
        }
        return false;
    }

    protected boolean setBestSeenSolution(O candidate) {
        boolean isBetterThanCurrent = this.bestSeenSolution == null || candidate.getScore() != null && candidate.getScore().compareTo(this.bestSeenSolution.getScore()) < 0;
        this.bestSeenSolution = candidate;
        return isBetterThanCurrent;
    }

    @Override
    public O nextSolutionCandidate() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException, AlgorithmException {
        ScoredItem candidate = (ScoredItem)super.nextSolutionCandidate();
        this.updateBestSeenSolution(candidate);
        return (O)candidate;
    }

    @Override
    public SolutionCandidateFoundEvent<O> nextSolutionCandidateEvent() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException, AlgorithmException {
        while (this.hasNext()) {
            AlgorithmEvent event = this.nextWithException();
            if (!(event instanceof SolutionCandidateFoundEvent)) continue;
            SolutionCandidateFoundEvent castedEvent = (SolutionCandidateFoundEvent)event;
            return castedEvent;
        }
        throw new NoSuchElementException();
    }

    public O getBestSeenSolution() {
        return this.bestSeenSolution;
    }

    @Override
    public O call() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmTimeoutedException, AlgorithmException {
        while (this.hasNext()) {
            this.nextWithException();
        }
        return this.bestSeenSolution;
    }

    @Override
    public String getLoggerName() {
        return this.loggerName;
    }

    @Override
    public void setLoggerName(String name) {
        this.logger.info("Switching logger from {} to {}", (Object)this.logger.getName(), (Object)name);
        this.loggerName = name;
        this.logger = LoggerFactory.getLogger((String)name);
        this.logger.info("Activated logger {} with name {}", (Object)name, (Object)this.logger.getName());
        super.setLoggerName(this.loggerName + "._algorithm");
    }
}

