/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.basic;

import java.util.Collection;
import org.apache.commons.math3.stat.inference.MannWhitneyUTest;
import org.apache.commons.math3.stat.inference.TTest;
import org.apache.commons.math3.stat.inference.WilcoxonSignedRankTest;

public class StatisticsUtil {
    private StatisticsUtil() {
    }

    public static double max(Collection<? extends Number> values) {
        return values.stream().mapToDouble(Number::doubleValue).max().getAsDouble();
    }

    public static double min(Collection<? extends Number> values) {
        return values.stream().mapToDouble(Number::doubleValue).min().getAsDouble();
    }

    public static double mean(Collection<? extends Number> values) {
        return values.stream().mapToDouble(Number::doubleValue).average().getAsDouble();
    }

    public static double sum(Collection<? extends Number> values) {
        return values.stream().mapToDouble(Number::doubleValue).sum();
    }

    public static double variance(Collection<? extends Number> values) {
        double mean = StatisticsUtil.mean(values);
        return values.stream().mapToDouble(Number::doubleValue).map(x -> Math.pow(x - mean, 2.0) / (double)values.size()).sum();
    }

    public static double standardDeviation(Collection<? extends Number> values) {
        return Math.sqrt(StatisticsUtil.variance(values));
    }

    public static double wilcoxonSignedRankSumTestP(double[] sampleA, double[] sampleB) {
        return new WilcoxonSignedRankTest().wilcoxonSignedRankTest(sampleA, sampleB, false);
    }

    public static boolean wilcoxonSignedRankSumTestTwoSided(double[] sampleA, double[] sampleB) {
        return StatisticsUtil.wilcoxonSignedRankSumTestP(sampleA, sampleB) < 0.05;
    }

    public static boolean wilcoxonSignedRankSumTestSingleSided(double[] sampleA, double[] sampleB) {
        return StatisticsUtil.wilcoxonSignedRankSumTestP(sampleA, sampleB) < 0.01;
    }

    public static double mannWhitneyTwoSidedSignificanceP(double[] sampleA, double[] sampleB) {
        return new MannWhitneyUTest().mannWhitneyUTest(sampleA, sampleB);
    }

    public static boolean mannWhitneyTwoSidedSignificance(double[] sampleA, double[] sampleB) {
        return StatisticsUtil.mannWhitneyTwoSidedSignificanceP(sampleA, sampleB) < 0.05;
    }

    public static boolean mannWhitneyTwoSidedSignificance(Collection<Double> sampleA, Collection<Double> sampleB) {
        return StatisticsUtil.mannWhitneyTwoSidedSignificance(StatisticsUtil.collectionToArray(sampleA), StatisticsUtil.collectionToArray(sampleB));
    }

    public static boolean mannWhitneyOneSidedSignificance(double[] sampleA, double[] sampleB) {
        return StatisticsUtil.mannWhitneyTwoSidedSignificanceP(sampleA, sampleB) < 0.01;
    }

    public static boolean twoSampleTTestSignificance(Collection<Double> valuesA, Collection<Double> valuesB) {
        return StatisticsUtil.twoSampleTTestSignificance(StatisticsUtil.collectionToArray(valuesA), StatisticsUtil.collectionToArray(valuesB));
    }

    public static boolean twoSampleTTestSignificance(double[] valuesA, double[] valuesB) {
        return new TTest().tTest(valuesA, valuesB, 0.05);
    }

    public static boolean twoSampleTTestSignificance(double mean1, double variance1, double n1, double mean2, double variance2, double n2) {
        double meanDifference = mean1 - mean2;
        double sP = Math.sqrt(((n1 - 1.0) * variance1 + (n2 - 1.0) * variance2) / (n1 + n2 - 2.0));
        double t = meanDifference / (sP * Math.sqrt(1.0 / n1 + 1.0 / n2));
        return t < 0.05;
    }

    private static double[] collectionToArray(Collection<Double> collection) {
        return collection.stream().mapToDouble(x -> x).toArray();
    }
}

