/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.logging;

import ai.libs.jaicore.basic.sets.SetUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class LoggerUtil {
    public static String getExceptionInfo(Throwable e) {
        return LoggerUtil.getExceptionInfo(e, new ArrayList<SetUtil.Pair<String, Object>>());
    }

    public static String getExceptionInfo(Throwable e, List<SetUtil.Pair<String, Object>> additionalInformationObjects) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n\tError class: ");
        sb.append(e.getClass().getName());
        sb.append("\n\tError message: ");
        if (e.getMessage() != null) {
            sb.append(e.getMessage().replace("\n", "\n\t\t"));
        } else {
            sb.append("NaN");
        }
        sb.append("\n\tError trace:");
        Arrays.asList(e.getStackTrace()).forEach(ste -> sb.append("\n\t\t" + ste.toString()));
        while (e.getCause() != null) {
            e = e.getCause();
            sb.append("\n\tCaused by " + e.getClass().getName() + " with message " + e.getMessage() + ". Stack trace of the cause:");
            Arrays.asList(e.getStackTrace()).forEach(ste -> sb.append("\n\t\t" + ste.toString()));
        }
        if (additionalInformationObjects != null) {
            for (SetUtil.Pair<String, Object> additionalObject : additionalInformationObjects) {
                sb.append("\n\t" + additionalObject.getX() + "\n\t\t");
                sb.append(additionalObject.getY().toString().replaceAll("\n", "\n\t\t"));
            }
        }
        return sb.toString();
    }

    public static String logException(Throwable e) {
        return LoggerUtil.getExceptionInfo(e, new ArrayList<SetUtil.Pair<String, Object>>());
    }
}

