/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.interrupt;

import ai.libs.jaicore.interrupt.Interrupt;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Interrupter {
    private static final Logger logger = LoggerFactory.getLogger(Interrupter.class);
    private static final Interrupter instance = new Interrupter();
    private final Map<Thread, Set<Object>> blackListedInterruptReasons = new HashMap<Thread, Set<Object>>();
    private final List<Interrupt> openInterrupts = new LinkedList<Interrupt>();

    private Interrupter() {
    }

    public static Interrupter get() {
        return instance;
    }

    public synchronized void interruptThread(Thread t, Object reason) {
        if (this.blackListedInterruptReasons.containsKey(t) && this.blackListedInterruptReasons.get(t).contains(reason)) {
            this.blackListedInterruptReasons.get(t).remove(reason);
            logger.info("Thread {} is not interrupted, because it has been marked to be avoided for reason {}. Removing the entry from the black list.", (Object)t, reason);
            return;
        }
        this.openInterrupts.add(new Interrupt(Thread.currentThread(), t, System.currentTimeMillis(), reason));
        logger.info("Interrupting {} on behalf of {} with reason {}", new Object[]{t, Thread.currentThread(), reason});
        t.interrupt();
        logger.info("Interrupt accomplished. Interrupt flag of {}: {}", (Object)t, (Object)t.isInterrupted());
    }

    public boolean hasCurrentThreadBeenInterruptedWithReason(Object reason) {
        return this.hasThreadBeenInterruptedWithReason(Thread.currentThread(), reason);
    }

    public Optional<Interrupt> getInterruptOfCurrentThreadWithReason(Object reason) {
        return this.getInterruptOfThreadWithReason(Thread.currentThread(), reason);
    }

    public Optional<Interrupt> getInterruptOfThreadWithReason(Thread thread, Object reason) {
        return this.openInterrupts.stream().filter(i -> i.getInterruptedThread() == thread && i.getReasonForInterruption().equals(reason)).findFirst();
    }

    public void avoidInterrupt(Thread t, Object reason) {
        if (!this.blackListedInterruptReasons.containsKey(t)) {
            this.blackListedInterruptReasons.put(t, new HashSet());
        }
        this.blackListedInterruptReasons.get(t).add(reason);
    }

    public boolean hasThreadBeenInterruptedWithReason(Thread thread, Object reason) {
        boolean matches = this.openInterrupts.stream().anyMatch(i -> i.getInterruptedThread() == thread && i.getReasonForInterruption().equals(reason));
        if (logger.isDebugEnabled()) {
            if (matches) {
                logger.debug("Reasons for why thread {} has currently been interrupted: {}. Checked reason {} matched? {}", new Object[]{thread, this.openInterrupts.stream().filter(t -> t.getInterruptedThread() == thread).map(Interrupt::getReasonForInterruption).collect(Collectors.toList()), reason, matches});
            } else {
                logger.debug("Thread {} is currently not interrupted. In particular, it is not interrupted with reason {}", (Object)thread, reason);
            }
        }
        return matches;
    }

    public Collection<Interrupt> getAllUnresolvedInterrupts() {
        return this.openInterrupts;
    }

    public Collection<Interrupt> getAllUnresolvedInterruptsOfThread(Thread thread) {
        return this.openInterrupts.stream().filter(i -> i.getInterruptedThread() == thread).collect(Collectors.toList());
    }

    public Optional<Interrupt> getLatestUnresolvedInterruptOfThread(Thread thread) {
        return this.getAllUnresolvedInterruptsOfThread(thread).stream().sorted((i1, i2) -> Long.compare(i1.getTimestampOfInterruption(), i2.getTimestampOfInterruption())).findFirst();
    }

    public Optional<Interrupt> getLatestUnresolvedInterruptOfCurrentThread() {
        return this.getLatestUnresolvedInterruptOfThread(Thread.currentThread());
    }

    public boolean hasCurrentThreadOpenInterrupts() {
        Thread currentThread = Thread.currentThread();
        return this.openInterrupts.stream().anyMatch(i -> i.getInterruptedThread() == currentThread);
    }

    public synchronized void markInterruptOnCurrentThreadAsResolved(Object reason) throws InterruptedException {
        Thread ct = Thread.currentThread();
        this.markInterruptAsResolved(ct, reason);
        if (this.hasCurrentThreadOpenInterrupts()) {
            Thread.interrupted();
            logger.info("Throwing a new InterruptedException after having resolved the current interrupt, because the thread still has open interrupts! The reasons for these are: {}", this.getAllUnresolvedInterruptsOfThread(ct).stream().map(Interrupt::getReasonForInterruption).collect(Collectors.toList()));
            throw new InterruptedException();
        }
    }

    public synchronized void markInterruptAsResolved(Thread t, Object reason) {
        if (!this.hasThreadBeenInterruptedWithReason(t, reason)) {
            throw new IllegalArgumentException("The thread " + t + " has not been interrupted with reason " + reason + ". Reasons for which it has been interrupted: " + Interrupter.get().getAllUnresolvedInterruptsOfThread(Thread.currentThread()).stream().map(Interrupt::getReasonForInterruption).collect(Collectors.toList()));
        }
        logger.debug("Removing interrupt with reason {} from list of open interrupts for thread {}", reason, (Object)t);
        this.openInterrupts.removeIf(i -> i.getInterruptedThread() == t && i.getReasonForInterruption().equals(reason));
        if (this.getAllUnresolvedInterruptsOfThread(t).contains(reason)) {
            throw new IllegalStateException("The interrupt should have been resolved, but it has not!");
        }
    }
}

