/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.client.concept;

import ai.grakn.client.concept.RemoteConcept;
import ai.grakn.client.rpc.RequestBuilder;
import ai.grakn.concept.Attribute;
import ai.grakn.concept.AttributeType;
import ai.grakn.concept.Concept;
import ai.grakn.concept.Relationship;
import ai.grakn.concept.Role;
import ai.grakn.concept.Thing;
import ai.grakn.concept.Type;
import ai.grakn.rpc.proto.ConceptProto;
import java.util.Arrays;
import java.util.stream.Stream;

abstract class RemoteThing<SomeThing extends Thing, SomeType extends Type>
extends RemoteConcept<SomeThing>
implements Thing {
    RemoteThing() {
    }

    public final SomeType type() {
        ConceptProto.Method.Req method = ConceptProto.Method.Req.newBuilder().setThingTypeReq(ConceptProto.Thing.Type.Req.getDefaultInstance()).build();
        Concept concept = RemoteConcept.of(this.runMethod(method).getThingTypeRes().getType(), this.tx());
        return this.asCurrentType(concept);
    }

    public final boolean isInferred() {
        ConceptProto.Method.Req method = ConceptProto.Method.Req.newBuilder().setThingIsInferredReq(ConceptProto.Thing.IsInferred.Req.getDefaultInstance()).build();
        return this.runMethod(method).getThingIsInferredRes().getInferred();
    }

    public final Stream<Attribute<?>> keys(AttributeType ... attributeTypes) {
        ConceptProto.Method.Req method = ConceptProto.Method.Req.newBuilder().setThingKeysReq(ConceptProto.Thing.Keys.Req.newBuilder().addAllAttributeTypes(RequestBuilder.Concept.concepts(Arrays.asList(attributeTypes)))).build();
        int iteratorId = this.runMethod(method).getThingKeysIter().getId();
        return this.conceptStream(iteratorId, res -> res.getThingKeysIterRes().getAttribute()).map(Concept::asAttribute);
    }

    public final Stream<Attribute<?>> attributes(AttributeType ... attributeTypes) {
        ConceptProto.Method.Req method = ConceptProto.Method.Req.newBuilder().setThingAttributesReq(ConceptProto.Thing.Attributes.Req.newBuilder().addAllAttributeTypes(RequestBuilder.Concept.concepts(Arrays.asList(attributeTypes)))).build();
        int iteratorId = this.runMethod(method).getThingAttributesIter().getId();
        return this.conceptStream(iteratorId, res -> res.getThingAttributesIterRes().getAttribute()).map(Concept::asAttribute);
    }

    public final Stream<Relationship> relationships(Role ... roles) {
        ConceptProto.Method.Req method = ConceptProto.Method.Req.newBuilder().setThingRelationsReq(ConceptProto.Thing.Relations.Req.newBuilder().addAllRoles(RequestBuilder.Concept.concepts(Arrays.asList(roles)))).build();
        int iteratorId = this.runMethod(method).getThingRelationsIter().getId();
        return this.conceptStream(iteratorId, res -> res.getThingRelationsIterRes().getRelation()).map(Concept::asRelationship);
    }

    public final Stream<Role> roles() {
        ConceptProto.Method.Req method = ConceptProto.Method.Req.newBuilder().setThingRolesReq(ConceptProto.Thing.Roles.Req.getDefaultInstance()).build();
        int iteratorId = this.runMethod(method).getThingRolesIter().getId();
        return this.conceptStream(iteratorId, res -> res.getThingRolesIterRes().getRole()).map(Concept::asRole);
    }

    public final SomeThing has(Attribute attribute) {
        this.relhas(attribute);
        return (SomeThing)((Thing)this.asCurrentBaseType(this));
    }

    @Deprecated
    public final Relationship relhas(Attribute attribute) {
        ConceptProto.Method.Req method = ConceptProto.Method.Req.newBuilder().setThingRelhasReq(ConceptProto.Thing.Relhas.Req.newBuilder().setAttribute(RequestBuilder.Concept.concept((Concept)attribute))).build();
        Concept concept = RemoteConcept.of(this.runMethod(method).getThingRelhasRes().getRelation(), this.tx());
        return concept.asRelationship();
    }

    public final SomeThing unhas(Attribute attribute) {
        ConceptProto.Method.Req method = ConceptProto.Method.Req.newBuilder().setThingUnhasReq(ConceptProto.Thing.Unhas.Req.newBuilder().setAttribute(RequestBuilder.Concept.concept((Concept)attribute))).build();
        this.runMethod(method);
        return (SomeThing)((Thing)this.asCurrentBaseType(this));
    }

    abstract SomeType asCurrentType(Concept var1);
}

