/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.client.concept;

import ai.grakn.client.Grakn;
import ai.grakn.client.concept.AutoValue_RemoteRelationship;
import ai.grakn.client.concept.RemoteConcept;
import ai.grakn.client.concept.RemoteThing;
import ai.grakn.client.rpc.RequestBuilder;
import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.Relationship;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.concept.Thing;
import ai.grakn.rpc.proto.ConceptProto;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public abstract class RemoteRelationship
extends RemoteThing<Relationship, RelationshipType>
implements Relationship {
    static RemoteRelationship construct(Grakn.Transaction tx, ConceptId id) {
        return new AutoValue_RemoteRelationship(tx, id);
    }

    public final Map<Role, Set<Thing>> rolePlayersMap() {
        ConceptProto.Method.Req method = ConceptProto.Method.Req.newBuilder().setRelationRolePlayersMapReq(ConceptProto.Relation.RolePlayersMap.Req.getDefaultInstance()).build();
        int iteratorId = this.runMethod(method).getRelationRolePlayersMapIter().getId();
        Iterable rolePlayers = () -> new Grakn.Transaction.Iterator<ConceptProto.Relation.RolePlayersMap.Iter.Res>(this.tx(), iteratorId, res -> res.getConceptMethodIterRes().getRelationRolePlayersMapIterRes());
        HashMap<Role, Set<Thing>> rolePlayerMap = new HashMap<Role, Set<Thing>>();
        for (ConceptProto.Relation.RolePlayersMap.Iter.Res rolePlayer : rolePlayers) {
            Role role = RemoteConcept.of(rolePlayer.getRole(), this.tx()).asRole();
            Thing player = RemoteConcept.of(rolePlayer.getPlayer(), this.tx()).asThing();
            if (rolePlayerMap.containsKey(role)) {
                ((Set)rolePlayerMap.get(role)).add(player);
                continue;
            }
            rolePlayerMap.put(role, new HashSet<Thing>(Collections.singletonList(player)));
        }
        return rolePlayerMap;
    }

    public final Stream<Thing> rolePlayers(Role ... roles) {
        ConceptProto.Method.Req method = ConceptProto.Method.Req.newBuilder().setRelationRolePlayersReq(ConceptProto.Relation.RolePlayers.Req.newBuilder().addAllRoles(RequestBuilder.Concept.concepts(Arrays.asList(roles)))).build();
        int iteratorId = this.runMethod(method).getRelationRolePlayersIter().getId();
        return this.conceptStream(iteratorId, res -> res.getRelationRolePlayersIterRes().getThing()).map(Concept::asThing);
    }

    public final Relationship assign(Role role, Thing player) {
        ConceptProto.Method.Req method = ConceptProto.Method.Req.newBuilder().setRelationAssignReq(ConceptProto.Relation.Assign.Req.newBuilder().setRole(RequestBuilder.Concept.concept((Concept)role)).setPlayer(RequestBuilder.Concept.concept((Concept)player))).build();
        this.runMethod(method);
        return this.asCurrentBaseType(this);
    }

    public final void unassign(Role role, Thing player) {
        ConceptProto.Method.Req method = ConceptProto.Method.Req.newBuilder().setRelationUnassignReq(ConceptProto.Relation.Unassign.Req.newBuilder().setRole(RequestBuilder.Concept.concept((Concept)role)).setPlayer(RequestBuilder.Concept.concept((Concept)player))).build();
        this.runMethod(method);
    }

    @Override
    final RelationshipType asCurrentType(Concept concept) {
        return concept.asRelationshipType();
    }

    @Override
    final Relationship asCurrentBaseType(Concept other) {
        return other.asRelationship();
    }
}

