/*
 * Decompiled with CFR 0.152.
 */
package ai.expert.nlapi.v2.model;

import ai.expert.nlapi.exceptions.NLApiErrorCode;
import ai.expert.nlapi.exceptions.NLApiException;
import ai.expert.nlapi.v2.model.ContextLanguageInfo;
import java.util.List;

public class ContextInfo {
    private String name;
    private String description;
    private List<ContextLanguageInfo> languages;
    private String contract;

    public ContextLanguageInfo getLanguagesByName(String name) throws NLApiException {
        return this.languages.stream().filter(language -> language.getName().equals(name)).findAny().orElseThrow(() -> new NLApiException(NLApiErrorCode.REQUEST_UNKNOWN_LANGUAGE_ERROR));
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<ContextLanguageInfo> getLanguages() {
        return this.languages;
    }

    public String getContract() {
        return this.contract;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLanguages(List<ContextLanguageInfo> languages) {
        this.languages = languages;
    }

    public void setContract(String contract) {
        this.contract = contract;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContextInfo)) {
            return false;
        }
        ContextInfo other = (ContextInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<ContextLanguageInfo> this$languages = this.getLanguages();
        List<ContextLanguageInfo> other$languages = other.getLanguages();
        if (this$languages == null ? other$languages != null : !((Object)this$languages).equals(other$languages)) {
            return false;
        }
        String this$contract = this.getContract();
        String other$contract = other.getContract();
        return !(this$contract == null ? other$contract != null : !this$contract.equals(other$contract));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContextInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<ContextLanguageInfo> $languages = this.getLanguages();
        result = result * 59 + ($languages == null ? 43 : ((Object)$languages).hashCode());
        String $contract = this.getContract();
        result = result * 59 + ($contract == null ? 43 : $contract.hashCode());
        return result;
    }

    public String toString() {
        return "ContextInfo(name=" + this.getName() + ", description=" + this.getDescription() + ", languages=" + this.getLanguages() + ", contract=" + this.getContract() + ")";
    }

    public ContextInfo(String name, String description, List<ContextLanguageInfo> languages, String contract) {
        this.name = name;
        this.description = description;
        this.languages = languages;
        this.contract = contract;
    }

    public ContextInfo() {
    }
}

