/*
 * Decompiled with CFR 0.152.
 */
package ai.expert.nlapi.v2.edge;

import ai.expert.nlapi.exceptions.NLApiErrorCode;
import ai.expert.nlapi.exceptions.NLApiException;
import ai.expert.nlapi.utils.APIUtils;
import ai.expert.nlapi.utils.ObjectMapperAdapter;
import ai.expert.nlapi.v2.edge.InfoConfig;
import ai.expert.nlapi.v2.message.ResourcesInfoResponse;
import ai.expert.nlapi.v2.message.StatisticsInfoResponse;
import kong.unirest.HttpResponse;
import kong.unirest.ObjectMapper;
import kong.unirest.Unirest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Info {
    private static final Logger logger = LoggerFactory.getLogger(Info.class);
    private final String RESOURCES_URL;
    private final String STATISTICS_URL;
    private final String HEALTH_URL;

    public Info(InfoConfig config) {
        String host = config.getHost();
        this.RESOURCES_URL = String.format("%s/essex/packages", host);
        this.STATISTICS_URL = String.format("%s/essex/statistics", host);
        this.HEALTH_URL = String.format("%s/health", host);
        Unirest.config().addDefaultHeader("Content-Type", "application/json").addDefaultHeader("Accept", "application/json").setObjectMapper((ObjectMapper)new ObjectMapperAdapter());
    }

    public ResourcesInfoResponse resources() throws NLApiException {
        return this.getResourcesInfoResponse();
    }

    public StatisticsInfoResponse statistics() throws NLApiException {
        return this.getStatisticsInfoResponse();
    }

    public void health() throws NLApiException {
        HttpResponse response = Unirest.get((String)this.HEALTH_URL).asString();
        if (response.getStatus() != 200) {
            String msg = String.format("GET call to API %s return error status %d", this.HEALTH_URL, response.getStatus());
            logger.error(msg);
            throw new NLApiException(NLApiErrorCode.CONNECTION_ERROR, msg);
        }
    }

    private ResourcesInfoResponse getResourcesInfoResponse() throws NLApiException {
        String json = this.getInfoResponseString(this.RESOURCES_URL);
        ResourcesInfoResponse response = APIUtils.fromJSON(json, ResourcesInfoResponse.class);
        if (response.isSuccess()) {
            return response;
        }
        String msg = String.format("Edge Resources Info call return an error json: %s", json);
        logger.error(msg);
        throw new NLApiException(NLApiErrorCode.EXECUTION_REQUEST_ERROR, msg);
    }

    private StatisticsInfoResponse getStatisticsInfoResponse() throws NLApiException {
        String json = this.getInfoResponseString(this.STATISTICS_URL);
        StatisticsInfoResponse response = APIUtils.fromJSON(json, StatisticsInfoResponse.class);
        if (response.isSuccess()) {
            return response;
        }
        String msg = String.format("Edge Statistics Info call return an error json: %s", json);
        logger.error(msg);
        throw new NLApiException(NLApiErrorCode.EXECUTION_REQUEST_ERROR, msg);
    }

    private String getInfoResponseString(String url) throws NLApiException {
        logger.debug("Sending request to Edge Info API: " + url);
        HttpResponse response = Unirest.post((String)url).body("").asString();
        if (response.getStatus() != 200) {
            String msg = String.format("Edge Info call to API %s return error status %d", url, response.getStatus());
            logger.error(msg);
            throw new NLApiException(NLApiErrorCode.CONNECTION_ERROR, msg);
        }
        logger.info("Edge Info call successful");
        return (String)response.getBody();
    }
}

