/*
 * Decompiled with CFR 0.152.
 */
package ai.expert.nlapi.security;

import ai.expert.nlapi.utils.StringUtils;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;

public final class Credential {
    @JsonProperty
    private final String username;
    @JsonProperty
    private final String password;
    private final String token;

    public boolean isValid() {
        if (!StringUtils.isBlank(this.token)) {
            return true;
        }
        if (StringUtils.isBlank(this.username)) {
            return false;
        }
        return !StringUtils.isBlank(this.password);
    }

    public String toJSON() {
        return new ObjectMapper().writeValueAsString((Object)this);
    }

    public Credential(String username, String password, String token) {
        this.username = username;
        this.password = password;
        this.token = token;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getToken() {
        return this.token;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Credential)) {
            return false;
        }
        Credential other = (Credential)o;
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        return !(this$token == null ? other$token != null : !this$token.equals(other$token));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        return result;
    }

    public String toString() {
        return "Credential(username=" + this.getUsername() + ", password=" + this.getPassword() + ", token=" + this.getToken() + ")";
    }
}

