/*
 * Decompiled with CFR 0.152.
 */
package ai.devtools.selenium;

import ai.devtools.selenium.CollectionUtils;
import ai.devtools.selenium.JsonUtils;
import ai.devtools.selenium.NetUtils;
import ai.devtools.selenium.SmartDriverElement;
import ai.devtools.selenium.Utils;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Keyboard;
import org.openqa.selenium.interactions.Mouse;
import org.openqa.selenium.interactions.Sequence;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.ErrorHandler;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.SessionId;
import org.slf4j.helpers.MessageFormatter;

public class SmartDriver
extends RemoteWebDriver {
    private static String SDK_VERSION = "0.1.0";
    private Logger log = Logger.getLogger(SmartDriver.class);
    private OkHttpClient client;
    RemoteWebDriver driver;
    private String apiKey;
    private HttpUrl serverURL;
    private String prodUrl = "https://smartdriver.dev-tools.ai";
    private String testCaseName;
    private String lastTestCaseScreenshotUUID;
    double multiplier;
    private Boolean useClassifierDuringCreation;
    private Boolean testCaseCreationMode;

    public SmartDriver(RemoteWebDriver driver, String apiKey, Map<String, Object> initializationDict) throws IOException {
        String baseUrl;
        this.driver = driver;
        this.apiKey = apiKey;
        this.log.setLevel(org.apache.log4j.Level.INFO);
        BasicConfigurator.configure();
        this.testCaseName = (String)initializationDict.get("testCaseName");
        this.useClassifierDuringCreation = (Boolean)initializationDict.get("useClassifierDuringCreation");
        this.testCaseCreationMode = Utils.StrToBool(System.getenv("DEVTOOLSAI_INTERACTIVE"));
        if (this.testCaseName == null) {
            StackTraceElement[] sl = Thread.currentThread().getStackTrace();
            if (sl.length > 0) {
                StackTraceElement bottom = sl[sl.length - 1];
                this.testCaseName = String.format("%s.%s", bottom.getClassName(), bottom.getMethodName());
                this.log.info((Object)("No test case name was specified, defaulting to " + this.testCaseName));
            } else {
                this.testCaseName = "My first test case";
            }
        }
        this.serverURL = HttpUrl.parse((String)((baseUrl = (String)initializationDict.get("serverURL")) != null ? baseUrl : Objects.requireNonNullElse(System.getenv("DEVTOOLSAI_URL"), this.prodUrl)));
        this.client = this.serverURL.equals((Object)HttpUrl.parse((String)"https://smartdriver.dev-tools.ai")) ? NetUtils.unsafeClient() : NetUtils.basicClient().build();
        this.multiplier = 1.0 * (double)ImageIO.read((File)driver.getScreenshotAs(OutputType.FILE)).getWidth() / (double)driver.manage().window().getSize().width;
        this.log.debug((Object)("The screen multiplier is " + this.multiplier));
        try {
            JsonObject payload = CollectionUtils.keyValuesToJO("api_key", apiKey, "os", String.format("%s-%s-%s", System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch")), "sdk_version", SDK_VERSION, "language", String.format("java-%s", System.getProperty("java.version")), "test_case_name", this.testCaseName);
            this.log.debug((Object)MessageFormatter.format((String)"Checking in with: {}", (Object)payload.toString()).toString());
            JsonObject r = JsonUtils.responseAsJson(NetUtils.basicPOST(this.client, this.serverURL, "ping", payload));
            if (!JsonUtils.booleanFromJson(r, "success")) {
                this.log.debug((Object)MessageFormatter.format((String)"Error during checkin, server said: {}", (Object)r.toString()).getMessage());
            }
        }
        catch (Throwable e) {
            this.log.debug((Object)MessageFormatter.format((String)"Checkin failed catastrophically: {}", (Object)e.getMessage()).getMessage());
        }
    }

    public SmartDriver(RemoteWebDriver driver, String apiKey) throws IOException {
        this(driver, apiKey, new HashMap<String, Object>());
    }

    public SmartDriver implicitlyWait(long waitTime) {
        this.driver.manage().timeouts().implicitlyWait(waitTime, TimeUnit.SECONDS);
        return this;
    }

    public Object executeAsyncScript(String script, Object ... args) {
        return this.driver.executeAsyncScript(script, args);
    }

    public Object executeScript(String script, Object ... args) {
        return this.driver.executeScript(script, args);
    }

    public void get(String url) {
        this.driver.get(url);
    }

    public WebElement findElement(By locator, String elementName) {
        if (elementName == null) {
            elementName = String.format("element_name_by_locator_%s", locator.toString().replace('.', '_').replace(' ', '_'));
        }
        try {
            String key;
            WebElement driverElement = this.driver.findElement(locator);
            if (driverElement != null && (key = this.uploadScreenshotIfNecessary(elementName)) != null) {
                this.updateElement(driverElement, key, elementName, true);
            }
            return driverElement;
        }
        catch (Throwable x) {
            this.log.info((Object)MessageFormatter.format((String)"Element '{}' was not found by Selenium, trying with Smartdriver...", (Object)elementName).getMessage());
            ClassifyResult result = this.classify(elementName);
            if (result.e != null) {
                return result.e;
            }
            this.log.error((Object)result.msg);
            this.log.error((Object)MessageFormatter.format((String)"Smartdriver was also unable to find the element with name '{}'", (Object)elementName).getMessage());
            throw x;
        }
    }

    public WebElement findElement(By locator) {
        return this.findElement(locator, null);
    }

    public List<WebElement> findElements(By locator) {
        return this.driver.findElements(locator);
    }

    public Capabilities getCapabilities() {
        return this.driver.getCapabilities();
    }

    public CommandExecutor getCommandExecutor() {
        return this.driver.getCommandExecutor();
    }

    public String getCurrentUrl() {
        return this.driver.getCurrentUrl();
    }

    public ErrorHandler getErrorHandler() {
        return this.driver.getErrorHandler();
    }

    public FileDetector getFileDetector() {
        return this.driver.getFileDetector();
    }

    public Keyboard getKeyboard() {
        return this.driver.getKeyboard();
    }

    public Mouse getMouse() {
        return this.driver.getMouse();
    }

    public String getPageSource() {
        return this.driver.getPageSource();
    }

    public <X> X getScreenshotAs(OutputType<X> outputType) {
        return (X)this.driver.getScreenshotAs(outputType);
    }

    public SessionId getSessionId() {
        return this.driver.getSessionId();
    }

    public String getTitle() {
        return this.driver.getTitle();
    }

    public String getWindowHandle() {
        return this.driver.getWindowHandle();
    }

    public Set<String> getWindowHandles() {
        return this.driver.getWindowHandles();
    }

    public WebDriver.Options manage() {
        return this.driver.manage();
    }

    public WebDriver.Navigation navigate() {
        return this.driver.navigate();
    }

    public void perform(Collection<Sequence> actions) {
        this.driver.perform(actions);
    }

    public void quit() {
        this.driver.quit();
    }

    public void resetInputState() {
        this.driver.resetInputState();
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.driver.setErrorHandler(handler);
    }

    public void setFileDetector(FileDetector detector) {
        this.driver.setFileDetector(detector);
    }

    public void setLogLevel(Level level) {
        this.driver.setLogLevel(level);
    }

    public WebDriver.TargetLocator switchTo() {
        return this.driver.switchTo();
    }

    public String toString() {
        return this.driver.toString();
    }

    public WebElement findElementByClassName(String using, String elementName) {
        return this.findElementByGeneric(using, elementName, "class_name", arg_0 -> ((RemoteWebDriver)this.driver).findElementByClassName(arg_0));
    }

    public WebElement findElementByClassName(String using) {
        return this.findElementByClassName(using, null);
    }

    public List<WebElement> findElementsByClassName(String using) {
        return this.driver.findElementsByClassName(using);
    }

    public WebElement findElementByCssSelector(String using, String elementName) {
        return this.findElementByGeneric(using, elementName, "class_name", arg_0 -> ((RemoteWebDriver)this.driver).findElementByCssSelector(arg_0));
    }

    public WebElement findElementByCssSelector(String using) {
        return this.findElementByCssSelector(using, null);
    }

    public List<WebElement> findElementsByCssSelector(String using) {
        return this.driver.findElementsByCssSelector(using);
    }

    public WebElement findElementById(String using, String elementName) {
        return this.findElementByGeneric(using, elementName, "class_name", arg_0 -> ((RemoteWebDriver)this.driver).findElementById(arg_0));
    }

    public WebElement findElementById(String using) {
        return this.findElementById(using, null);
    }

    public List<WebElement> findElementsById(String using) {
        return this.driver.findElementsById(using);
    }

    public WebElement findElementByLinkText(String using, String elementName) {
        return this.findElementByGeneric(using, elementName, "class_name", arg_0 -> ((RemoteWebDriver)this.driver).findElementByLinkText(arg_0));
    }

    public WebElement findElementByLinkText(String using) {
        return this.findElementByLinkText(using, null);
    }

    public List<WebElement> findElementsByLinkText(String using) {
        return this.driver.findElementsByLinkText(using);
    }

    public WebElement findElementByName(String using, String elementName) {
        return this.findElementByGeneric(using, elementName, "name", arg_0 -> ((RemoteWebDriver)this.driver).findElementByName(arg_0));
    }

    public WebElement findElementByName(String using) {
        return this.findElementByName(using, null);
    }

    public List<WebElement> findElementsByName(String using) {
        return this.driver.findElementsByName(using);
    }

    public WebElement findElementByPartialLinkText(String using, String elementName) {
        return this.findElementByGeneric(using, elementName, "name", arg_0 -> ((RemoteWebDriver)this.driver).findElementByPartialLinkText(arg_0));
    }

    public WebElement findElementByPartialLinkText(String using) {
        return this.findElementByPartialLinkText(using, null);
    }

    public List<WebElement> findElementsByPartialLinkText(String using) {
        return this.driver.findElementsByPartialLinkText(using);
    }

    public WebElement findElementByTagName(String using, String elementName) {
        return this.findElementByGeneric(using, elementName, "name", arg_0 -> ((RemoteWebDriver)this.driver).findElementByTagName(arg_0));
    }

    public WebElement findElementByTagName(String using) {
        return this.findElementByTagName(using, null);
    }

    public List<WebElement> findElementsByTagName(String using) {
        return this.driver.findElementsByTagName(using);
    }

    public WebElement findElementByXPath(String using, String elementName) {
        return this.findElementByGeneric(using, elementName, "xpath", arg_0 -> ((RemoteWebDriver)this.driver).findElementByXPath(arg_0));
    }

    public WebElement findElementByXPath(String using) {
        return this.findElementByXPath(using, null);
    }

    public List<WebElement> findElementsByXPath(String using) {
        return this.driver.findElementsByXPath(using);
    }

    @Deprecated
    public WebElement findByElementName(String elementName) {
        return this.findElementByElementName(elementName);
    }

    public WebElement findElementByElementName(String elementName) {
        ClassifyResult r = this.classify(elementName);
        if (r.e == null) {
            throw new NoSuchElementException(r.msg);
        }
        return r.e;
    }

    public WebElement findByAI(String elementName) {
        return this.findElementByElementName(elementName);
    }

    private String getScreenshotHash(String screenshotBase64) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] md5sum = md.digest(screenshotBase64.getBytes());
            String output = String.format("%032X", new BigInteger(1, md5sum));
            return output.toLowerCase();
        }
        catch (Throwable e) {
            return "";
        }
    }

    private JsonObject checkScreenshotExists(String screenshotUUID, String elementName) {
        JsonObject payload = new JsonObject();
        payload.addProperty("api_key", this.apiKey);
        payload.addProperty("label", elementName);
        payload.addProperty("screenshot_uuid", screenshotUUID);
        try {
            JsonObject res = JsonUtils.responseAsJson(NetUtils.basicPOST(this.client, this.serverURL, "exists_screenshot", payload));
            return res;
        }
        catch (Throwable e) {
            this.log.debug((Object)"Error checking if screenshot exists");
            e.printStackTrace();
            return null;
        }
    }

    private JsonObject uploadScreenshot(String screenshotBase64, String elementName) {
        JsonObject payload = new JsonObject();
        payload.addProperty("api_key", this.apiKey);
        payload.addProperty("label", elementName);
        payload.addProperty("screenshot", screenshotBase64);
        payload.addProperty("test_case_name", this.testCaseName);
        try {
            JsonObject res = JsonUtils.responseAsJson(NetUtils.basicPOST(this.client, this.serverURL, "upload_screenshot", payload));
            return res;
        }
        catch (Throwable e) {
            this.log.debug((Object)"Error uploading screenshot");
            e.printStackTrace();
            return null;
        }
    }

    private JsonObject uploadTCScreenshot(String screenshotBase64, String elementName) {
        JsonObject payload = new JsonObject();
        payload.addProperty("api_key", this.apiKey);
        payload.addProperty("label", elementName);
        payload.addProperty("screenshot", screenshotBase64);
        payload.addProperty("test_case_name", this.testCaseName);
        payload.addProperty("is_interactive", Boolean.valueOf(true));
        try {
            JsonObject res = JsonUtils.responseAsJson(NetUtils.basicPOST(this.client, this.serverURL, "upload_screenshot", payload));
            return res;
        }
        catch (Throwable e) {
            this.log.debug((Object)"Error uploading test case screenshot");
            e.printStackTrace();
            return null;
        }
    }

    private String uploadScreenshotIfNecessary(String elementName) {
        Boolean isElementFrozen = this.checkIfFrozen(elementName);
        if (isElementFrozen.booleanValue()) {
            return null;
        }
        String screenshotBase64 = (String)this.driver.getScreenshotAs(OutputType.BASE64);
        String screenshotUUID = this.getScreenshotHash(screenshotBase64);
        JsonObject screenshotExistsResponse = this.checkScreenshotExists(screenshotUUID, elementName);
        if (screenshotExistsResponse != null && screenshotExistsResponse.get("exists_screenshot").getAsBoolean()) {
            return screenshotUUID;
        }
        JsonObject uploadScreenshotResponse = this.uploadScreenshot(screenshotBase64, elementName);
        if (uploadScreenshotResponse != null) {
            if (uploadScreenshotResponse.get("success").getAsBoolean()) {
                return uploadScreenshotResponse.get("screenshot_uuid").getAsString();
            }
            this.log.info((Object)"Error uploading screenshot");
            return screenshotUUID;
        }
        this.log.info((Object)"Error uploading screenshot");
        return screenshotUUID;
    }

    private Boolean checkIfFrozen(String elementName) {
        JsonObject payload = new JsonObject();
        payload.addProperty("api_key", this.apiKey);
        payload.addProperty("label", elementName);
        try {
            JsonObject res = JsonUtils.responseAsJson(NetUtils.basicPOST(this.client, this.serverURL, "check_frozen", payload));
            return res.get("is_frozen").getAsBoolean();
        }
        catch (Throwable e) {
            this.log.debug((Object)"Error checking if element is frozen");
            e.printStackTrace();
            return true;
        }
    }

    private WebElement findElementByGeneric(String using, String elementName, String shortcode, Function<String, WebElement> fn) {
        if (elementName == null) {
            elementName = String.format("element_name_by_%s_%s", shortcode, using.replace('.', '_'));
        }
        try {
            String key;
            WebElement driverElement = fn.apply(using);
            if (driverElement != null && (key = this.uploadScreenshotIfNecessary(elementName)) != null) {
                this.updateElement(driverElement, key, elementName, true);
            }
            return driverElement;
        }
        catch (Throwable x) {
            this.log.info((Object)MessageFormatter.format((String)"Element '{}' was not found by Selenium, trying with Smartdriver...", (Object)elementName).getMessage());
            ClassifyResult result = this.classify(elementName);
            if (result.e != null) {
                return result.e;
            }
            this.log.error((Object)result.msg);
            this.log.error((Object)MessageFormatter.format((String)"Smartdriver was also unable to find the element with name '{}'", (Object)elementName).getMessage());
            throw x;
        }
    }

    protected void updateElement(WebElement elem, String screenshotUUID, String elementName, boolean trainIfNecessary) {
        Rectangle rect = elem.getRect();
        JsonObject payload = new JsonObject();
        payload.addProperty("screenshot_uuid", screenshotUUID);
        payload.addProperty("retrain", Boolean.valueOf(trainIfNecessary));
        payload.addProperty("api_key", this.apiKey);
        payload.addProperty("label", elementName);
        payload.addProperty("x", (Number)((double)rect.x * this.multiplier));
        payload.addProperty("y", (Number)((double)rect.y * this.multiplier));
        payload.addProperty("width", (Number)((double)rect.width * this.multiplier));
        payload.addProperty("height", (Number)((double)rect.height * this.multiplier));
        payload.addProperty("multiplier", (Number)this.multiplier);
        payload.addProperty("test_case_name", this.testCaseName);
        try {
            JsonUtils.responseAsJson(NetUtils.basicPOST(this.client, this.serverURL, "add_action_info", payload));
        }
        catch (Throwable e) {
            this.log.debug((Object)"Error updating element");
            e.printStackTrace();
        }
    }

    private JsonObject getTCBox(String elementName) {
        JsonObject payload = new JsonObject();
        payload.addProperty("api_key", this.apiKey);
        payload.addProperty("label", elementName);
        payload.addProperty("screenshot_uuid", this.lastTestCaseScreenshotUUID);
        payload.addProperty("run_classifier", this.useClassifierDuringCreation);
        try {
            JsonObject res = JsonUtils.responseAsJson(NetUtils.basicPOST(this.client, this.serverURL, "testcase/get_action_info", payload));
            return res;
        }
        catch (Throwable e) {
            this.log.debug((Object)"Error getting TC box");
            e.printStackTrace();
            return null;
        }
    }

    private void openBrowser(String url) {
        try {
            String os = System.getProperty("os.name").toLowerCase();
            if (os.contains("mac")) {
                Runtime.getRuntime().exec("open " + url);
            } else if (os.contains("windows")) {
                Runtime.getRuntime().exec("run " + url);
            } else {
                this.log.info((Object)MessageFormatter.format((String)"Please open the following URL in your browser: {}", (Object)url).getMessage());
            }
        }
        catch (Throwable e) {
            this.log.info((Object)MessageFormatter.format((String)"Please open the following URL in your browser: {}", (Object)url).getMessage());
        }
    }

    protected ClassifyResult classify(String elementName) {
        if (this.testCaseCreationMode.booleanValue()) {
            String screenshotBase64 = (String)this.driver.getScreenshotAs(OutputType.BASE64);
            JsonObject res = this.uploadTCScreenshot(screenshotBase64, elementName);
            if (res.get("success").getAsBoolean()) {
                this.lastTestCaseScreenshotUUID = res.get("screenshot_uuid").getAsString();
                JsonObject boxResponse = this.getTCBox(elementName);
                if (boxResponse != null && boxResponse.get("success").getAsBoolean() && boxResponse.get("predicted_element") != JsonNull.INSTANCE) {
                    return new ClassifyResult(new SmartDriverElement(boxResponse.get("predicted_element").getAsJsonObject(), this), this.lastTestCaseScreenshotUUID);
                }
                String labelUrl = this.serverURL + "/testcase/label?test_case_name=" + URLEncoder.encode(this.testCaseName);
                this.openBrowser(labelUrl);
                while (true) {
                    if ((boxResponse = this.getTCBox(elementName)) != null && boxResponse.get("success").getAsBoolean() && boxResponse.get("predicted_element") != JsonNull.INSTANCE) {
                        return new ClassifyResult(new SmartDriverElement(boxResponse.get("predicted_element").getAsJsonObject(), this), this.lastTestCaseScreenshotUUID);
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            this.log.info((Object)"Failed to upload test case screenshot");
            this.log.info((Object)res.get("message").getAsString());
            return new ClassifyResult(null, this.lastTestCaseScreenshotUUID, res.get("message").getAsString());
        }
        String pageSource = "";
        String msg = "Smartdriver driver exception";
        String key = null;
        try {
            String screenshotBase64 = (String)this.driver.getScreenshotAs(OutputType.BASE64);
            String screenshotUUID = this.getScreenshotHash(screenshotBase64);
            JsonObject screenshotExistsResponse = this.checkScreenshotExists(screenshotUUID, elementName);
            if (screenshotExistsResponse != null && screenshotExistsResponse.get("success").getAsBoolean() && screenshotExistsResponse.get("predicted_element") != JsonNull.INSTANCE) {
                msg = screenshotExistsResponse.get("message").getAsString();
                this.log.info((Object)msg);
                return new ClassifyResult(new SmartDriverElement(screenshotExistsResponse.get("predicted_element").getAsJsonObject(), this), null);
            }
            JsonObject payload = new JsonObject();
            payload.addProperty("api_key", this.apiKey);
            payload.addProperty("label", elementName);
            payload.addProperty("screenshot", screenshotBase64);
            payload.addProperty("test_case_name", this.testCaseName);
            JsonObject classifyResponse = JsonUtils.responseAsJson(NetUtils.basicPOST(this.client, this.serverURL, "detect", payload));
            if (!classifyResponse.get("success").getAsBoolean()) {
                msg = classifyResponse.get("message").getAsString().replace(this.prodUrl, this.serverURL.toString());
                return new ClassifyResult(null, key, msg);
            }
            msg = classifyResponse.get("message").getAsString().replace(this.prodUrl, this.serverURL.toString());
            this.log.info((Object)msg);
            try {
                return new ClassifyResult(new SmartDriverElement(classifyResponse.get("predicted_element").getAsJsonObject(), this), classifyResponse.get("screenshot_uuid").getAsString());
            }
            catch (Throwable e) {
                this.log.error((Object)"Error creating SmartDriverElement from response");
                e.printStackTrace();
                return new ClassifyResult(null, key, msg);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.log.warn((Object)msg);
            return new ClassifyResult(null, key, msg);
        }
    }

    public void close() {
        this.driver.close();
    }

    private static class ClassifyResult {
        public SmartDriverElement e;
        public String key;
        public String msg;

        ClassifyResult(SmartDriverElement e, String key, String msg) {
            this.e = e;
            this.key = key;
            this.msg = msg;
        }

        ClassifyResult(SmartDriverElement e, String key) {
            this(e, key, "");
        }
    }
}

