/*
 * Decompiled with CFR 0.152.
 */
package ai.devtools.sdk;

import ai.devtools.sdk.JsonUtils;
import ai.devtools.sdk.MatchUtils;
import ai.devtools.sdk.SmartDriver;
import com.google.gson.JsonObject;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartDriverElement
extends RemoteWebElement {
    private static Logger log = LoggerFactory.getLogger(SmartDriverElement.class);
    private RemoteWebDriver driver;
    private WebElement realElement;
    private String text;
    private Dimension size;
    private Point location;
    private Rectangle rectangle;
    private String tagName;

    SmartDriverElement(JsonObject elem, SmartDriver driver) {
        log.debug("Creating new SmartDriverElement w/ {}", (Object)elem);
        this.driver = driver.driver;
        this.realElement = MatchUtils.matchBoundingBoxToSeleniumElement(elem, driver);
        this.text = JsonUtils.stringFromJson(elem, "text");
        this.size = new Dimension(JsonUtils.intFromJson(elem, "width") / (int)driver.multiplier, JsonUtils.intFromJson(elem, "height") / (int)driver.multiplier);
        this.location = new Point(JsonUtils.intFromJson(elem, "x") / (int)driver.multiplier, JsonUtils.intFromJson(elem, "y") / (int)driver.multiplier);
        this.rectangle = new Rectangle(this.location, this.size);
        this.tagName = JsonUtils.stringFromJson(elem, "class");
    }

    public String toString() {
        return "SmartDriverElement: " + this.text;
    }

    public String getText() {
        return this.text;
    }

    public Dimension getSize() {
        return this.size;
    }

    public Point getLocation() {
        return this.location;
    }

    public Rectangle getRect() {
        return this.rectangle;
    }

    public String getTagName() {
        return this.tagName;
    }

    public void clear() {
        this.realElement.clear();
    }

    public WebElement findElement(By by) {
        return this.driver.findElement(by);
    }

    public List<WebElement> findElements(By by) {
        return this.driver.findElements(by);
    }

    public String getAttribute(String name) {
        return this.realElement.getAttribute(name);
    }

    public String getCssValue(String propertyName) {
        return this.realElement.getCssValue(propertyName);
    }

    public boolean isDisplayed() {
        return this.realElement.isDisplayed();
    }

    public boolean isEnabled() {
        return this.realElement.isEnabled();
    }

    public boolean isSelected() {
        return this.realElement.isSelected();
    }

    public void click() {
        this.realElement.click();
    }

    public void sendKeys(CharSequence ... keysToSend) {
        this.realElement.sendKeys(keysToSend);
    }

    public void submit() {
        this.realElement.submit();
    }
}

