/*
 * Decompiled with CFR 0.152.
 */
package com.pingplusplus.util;

import com.pingplusplus.Pingpp;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import org.apache.commons.codec.binary.Base64;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;

public class PingppSignature {
    public static String sign(String string, String string2, String string3) {
        PrivateKey privateKey = PingppSignature.getPrivateKeyFromPEM(string2);
        if (privateKey == null) {
            return null;
        }
        try {
            Signature signature = Signature.getInstance("SHA256withRSA");
            signature.initSign(privateKey);
            signature.update(string.getBytes(string3));
            byte[] byArray = signature.sign();
            return Base64.encodeBase64String((byte[])byArray).replaceAll("\n|\r", "");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        catch (InvalidKeyException invalidKeyException) {
            invalidKeyException.printStackTrace();
        }
        catch (SignatureException signatureException) {
            signatureException.printStackTrace();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return null;
    }

    public static PrivateKey getPrivateKeyFromPEM(String string) {
        string = string.replaceAll("(-+BEGIN (RSA )?PRIVATE KEY-+\\r?\\n|-+END (RSA )?PRIVATE KEY-+\\r?\\n?)", "");
        byte[] byArray = Base64.decodeBase64((String)string);
        try {
            return PingppSignature.generatePrivateKeyWithPKCS8(byArray);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            if (Pingpp.DEBUG.booleanValue()) {
                invalidKeySpecException.printStackTrace();
            }
            return PingppSignature.generatePrivateKeyWithPKCS1(byArray);
        }
    }

    public static PrivateKey generatePrivateKeyWithPKCS8(byte[] byArray) throws InvalidKeySpecException {
        try {
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            return null;
        }
    }

    public static PrivateKey generatePrivateKeyWithPKCS1(byte[] byArray) {
        try {
            DerInputStream derInputStream = new DerInputStream(byArray);
            DerValue[] derValueArray = derInputStream.getSequence(0);
            if (derValueArray.length < 9) {
                System.out.println("Could not parse a PKCS1 private key.");
                return null;
            }
            BigInteger bigInteger = derValueArray[1].getBigInteger();
            BigInteger bigInteger2 = derValueArray[2].getBigInteger();
            BigInteger bigInteger3 = derValueArray[3].getBigInteger();
            BigInteger bigInteger4 = derValueArray[4].getBigInteger();
            BigInteger bigInteger5 = derValueArray[5].getBigInteger();
            BigInteger bigInteger6 = derValueArray[6].getBigInteger();
            BigInteger bigInteger7 = derValueArray[7].getBigInteger();
            BigInteger bigInteger8 = derValueArray[8].getBigInteger();
            RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = new RSAPrivateCrtKeySpec(bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePrivate(rSAPrivateCrtKeySpec);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            invalidKeySpecException.printStackTrace();
        }
        return null;
    }
}

