/*
 * Decompiled with CFR 0.152.
 */
package com.pingplusplus.net;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.pingplusplus.Pingpp;
import com.pingplusplus.exception.APIConnectionException;
import com.pingplusplus.exception.APIException;
import com.pingplusplus.exception.AuthenticationException;
import com.pingplusplus.exception.ChannelException;
import com.pingplusplus.exception.InvalidRequestException;
import com.pingplusplus.exception.RateLimitException;
import com.pingplusplus.model.Charge;
import com.pingplusplus.model.ChargeRefundCollection;
import com.pingplusplus.model.EventData;
import com.pingplusplus.model.PingppObject;
import com.pingplusplus.model.PingppRawJsonObject;
import com.pingplusplus.model.RedEnvelope;
import com.pingplusplus.model.SubApp;
import com.pingplusplus.model.Transfer;
import com.pingplusplus.net.PingppResponse;
import com.pingplusplus.serializer.ChargeDeserializer;
import com.pingplusplus.serializer.ChargeRefundCollectionDeserializer;
import com.pingplusplus.serializer.EventDataDeserializer;
import com.pingplusplus.serializer.PingppRawJsonObjectDeserializer;
import com.pingplusplus.serializer.RedEnvelopeDeserializer;
import com.pingplusplus.serializer.SubAppDeserializer;
import com.pingplusplus.serializer.TransferDeserializer;
import com.pingplusplus.util.PingppSignature;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import javax.net.ssl.HttpsURLConnection;

public abstract class APIResource
extends PingppObject {
    public static final String CHARSET = "UTF-8";
    private static final String REQUEST_TIME_KEY = "Pingplusplus-Request-Timestamp";
    public static int CONNECT_TIMEOUT = 30;
    public static int READ_TIMEOUT = 80;
    public static int RETRY_MAX = 1;
    public static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter(Charge.class, (Object)new ChargeDeserializer()).registerTypeAdapter(RedEnvelope.class, (Object)new RedEnvelopeDeserializer()).registerTypeAdapter(Transfer.class, (Object)new TransferDeserializer()).registerTypeAdapter(ChargeRefundCollection.class, (Object)new ChargeRefundCollectionDeserializer()).registerTypeAdapter(EventData.class, (Object)new EventDataDeserializer()).registerTypeAdapter(PingppRawJsonObject.class, (Object)new PingppRawJsonObjectDeserializer()).registerTypeAdapter(SubApp.class, (Object)new SubAppDeserializer()).create();

    public static Gson getGson() {
        try {
            Class<?> klass = Class.forName("com.pingplusplus.net.AppBasedResource");
            Field field = klass.getField("GSON");
            return (Gson)field.get(klass);
        }
        catch (ClassNotFoundException klass) {
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return GSON;
    }

    public static Class<?> getSelfClass() {
        return APIResource.class;
    }

    protected static String className(Class<?> clazz) {
        String className;
        switch (className = clazz.getSimpleName().toLowerCase().replace("$", " ")) {
            case "redenvelope": {
                return "red_envelope";
            }
            case "batchrefund": {
                return "batch_refund";
            }
            case "batchtransfer": {
                return "batch_transfer";
            }
            case "customs": {
                return "custom";
            }
            case "cardinfo": {
                return "card_info";
            }
            case "assettransaction": {
                return "asset_transaction";
            }
            case "balancebonus": {
                return "balance_bonuse";
            }
            case "balancetransfer": {
                return "balance_transfer";
            }
            case "balancetransaction": {
                return "balance_transaction";
            }
            case "coupontemplate": {
                return "coupon_template";
            }
            case "batchwithdrawal": {
                return "batch_withdrawal";
            }
            case "transactionstatistics": {
                return "transaction_statistics";
            }
            case "settleaccount": {
                return "settle_account";
            }
            case "subapp": {
                return "sub_app";
            }
            case "royalty": {
                return "royaltie";
            }
            case "royaltysettlement": {
                return "royalty_settlement";
            }
            case "royaltytransaction": {
                return "royalty_transaction";
            }
            case "royaltytemplate": {
                return "royalty_template";
            }
            case "balancesettlement": {
                return "balance_settlement";
            }
            case "subbank": {
                return "sub_bank";
            }
            case "splitreceiver": {
                return "split_receiver";
            }
            case "splitprofit": {
                return "split_profit";
            }
            case "profittransaction": {
                return "profit_transaction";
            }
            case "userpic": {
                return "users/upload_pic";
            }
            case "contact": {
                return "sub_apps/contact";
            }
        }
        return className;
    }

    protected static String singleClassURL(Class<?> clazz) throws InvalidRequestException {
        String className = null;
        Class<?> klass = APIResource.getSelfClass();
        if (!klass.getSimpleName().equalsIgnoreCase("APIResource")) {
            try {
                Method method = klass.getMethod("className", Class.class);
                className = (String)method.invoke(klass, clazz);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if (className == null) {
            className = APIResource.className(clazz);
        }
        return String.format("%s/v1/%s", Pingpp.getApiBase(), className);
    }

    protected static String classURL(Class<?> clazz) throws InvalidRequestException {
        return String.format("%ss", APIResource.singleClassURL(clazz));
    }

    protected static String instanceURL(Class<?> clazz, String id) throws InvalidRequestException {
        try {
            return String.format("%s/%s", APIResource.classURL(clazz), APIResource.urlEncode(id));
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidRequestException("Unable to encode parameters to UTF-8", null, e);
        }
    }

    protected static String apiBasePrefixedURL(String url) {
        return String.format("%s%s", Pingpp.getApiBase(), url);
    }

    protected static String urlEncode(String str) throws UnsupportedEncodingException {
        if (str == null) {
            return null;
        }
        return URLEncoder.encode(str, CHARSET);
    }

    private static String urlEncodePair(String k, String v) throws UnsupportedEncodingException {
        return String.format("%s=%s", APIResource.urlEncode(k), APIResource.urlEncode(v));
    }

    static Map<String, String> getHeaders(String apiKey) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept-Charset", CHARSET);
        headers.put("User-Agent", String.format("Pingpp/v1 JavaBindings/%s", "2.3.12"));
        if (apiKey == null) {
            apiKey = Pingpp.apiKey;
        }
        headers.put("Authorization", String.format("Bearer %s", apiKey));
        headers.put("Accept-Language", Pingpp.AcceptLanguage);
        String[] propertyNames = new String[]{"os.name", "os.version", "os.arch", "java.version", "java.vendor", "java.vm.version", "java.vm.vendor"};
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        for (String propertyName : propertyNames) {
            propertyMap.put(propertyName, System.getProperty(propertyName));
        }
        propertyMap.put("bindings.version", "2.3.12");
        propertyMap.put("lang", "Java");
        propertyMap.put("publisher", "Pingpp");
        headers.put("X-Pingpp-Client-User-Agent", APIResource.getGson().toJson(propertyMap));
        if (Pingpp.apiVersion != null) {
            headers.put("Pingplusplus-Version", Pingpp.apiVersion);
        }
        return headers;
    }

    private static HttpURLConnection createPingppConnection(String url, String apiKey) throws IOException {
        URL pingppURL = new URL(url);
        HttpURLConnection conn = pingppURL.getProtocol().equals("https") ? (HttpsURLConnection)pingppURL.openConnection() : (HttpURLConnection)pingppURL.openConnection();
        conn.setConnectTimeout(CONNECT_TIMEOUT * 1000);
        conn.setReadTimeout(READ_TIMEOUT * 1000);
        conn.setUseCaches(false);
        for (Map.Entry<String, String> header : APIResource.getHeaders(apiKey).entrySet()) {
            conn.setRequestProperty(header.getKey(), header.getValue());
        }
        return conn;
    }

    private static void throwInvalidCertificateException() throws APIConnectionException {
        throw new APIConnectionException("Invalid server certificate. You tried to connect to a server that has a revoked SSL certificate, which means we cannot securely send data to that server. ");
    }

    private static String formatURL(String url, String query) {
        if (query == null || query.isEmpty()) {
            return url;
        }
        String separator = url.contains("?") ? "&" : "?";
        return String.format("%s%s%s", url, separator, query);
    }

    private static HttpURLConnection createGetConnection(String url, String query, String apiKey) throws IOException, APIConnectionException {
        String getURL = APIResource.formatURL(url, query);
        HttpURLConnection conn = APIResource.createPingppConnection(getURL, apiKey);
        conn.setRequestMethod("GET");
        String requestTime = APIResource.currentTimeString();
        String stringToBeSigned = APIResource.getRequestURIFromURL(conn.getURL()) + requestTime;
        conn.setRequestProperty(REQUEST_TIME_KEY, requestTime);
        String signature = APIResource.generateSign(stringToBeSigned);
        if (signature != null) {
            conn.setRequestProperty("Pingplusplus-Signature", signature);
        }
        return conn;
    }

    private static HttpURLConnection createDeleteConnection(String url, String query, String apiKey) throws IOException, APIConnectionException {
        String getURL = APIResource.formatURL(url, query);
        HttpURLConnection conn = APIResource.createPingppConnection(getURL, apiKey);
        conn.setRequestMethod("DELETE");
        String requestTime = APIResource.currentTimeString();
        String stringToBeSigned = APIResource.getRequestURIFromURL(conn.getURL()) + requestTime;
        conn.setRequestProperty(REQUEST_TIME_KEY, requestTime);
        String signature = APIResource.generateSign(stringToBeSigned);
        if (signature != null) {
            conn.setRequestProperty("Pingplusplus-Signature", signature);
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpURLConnection createPostConnection(String url, String query, String apiKey) throws IOException, APIConnectionException {
        HttpURLConnection conn = APIResource.createPingppConnection(url, apiKey);
        conn.setDoOutput(true);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", String.format("application/json;charset=%s", CHARSET));
        String stringToBeSigned = query;
        stringToBeSigned = stringToBeSigned + APIResource.getRequestURIFromURL(conn.getURL());
        String requestTime = APIResource.currentTimeString();
        stringToBeSigned = stringToBeSigned + requestTime;
        String signature = APIResource.generateSign(stringToBeSigned);
        if (signature != null) {
            conn.setRequestProperty("Pingplusplus-Signature", signature);
        }
        conn.setRequestProperty(REQUEST_TIME_KEY, requestTime);
        try (OutputStream output = null;){
            output = conn.getOutputStream();
            output.write(query.getBytes(CHARSET));
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpURLConnection createPutConnection(String url, String query, String apiKey) throws IOException, APIConnectionException {
        HttpURLConnection conn = APIResource.createPingppConnection(url, apiKey);
        conn.setDoOutput(true);
        conn.setRequestMethod("PUT");
        conn.setRequestProperty("Content-Type", String.format("application/json;charset=%s", CHARSET));
        String stringToBeSigned = query;
        stringToBeSigned = stringToBeSigned + APIResource.getRequestURIFromURL(conn.getURL());
        String requestTime = APIResource.currentTimeString();
        stringToBeSigned = stringToBeSigned + requestTime;
        String signature = APIResource.generateSign(stringToBeSigned);
        if (signature != null) {
            conn.setRequestProperty("Pingplusplus-Signature", signature);
        }
        conn.setRequestProperty(REQUEST_TIME_KEY, requestTime);
        try (OutputStream output = null;){
            output = conn.getOutputStream();
            output.write(query.getBytes(CHARSET));
        }
        return conn;
    }

    private static String createQuery(Map<String, Object> params) throws UnsupportedEncodingException, InvalidRequestException {
        Map<String, String> flatParams = APIResource.flattenParams(params);
        StringBuilder queryStringBuffer = new StringBuilder();
        for (Map.Entry<String, String> entry : flatParams.entrySet()) {
            if (queryStringBuffer.length() > 0) {
                queryStringBuffer.append("&");
            }
            queryStringBuffer.append(APIResource.urlEncodePair(entry.getKey(), entry.getValue()));
        }
        return queryStringBuffer.toString();
    }

    private static String createJSONString(Map<String, Object> params) {
        Gson gson = new GsonBuilder().enableComplexMapKeySerialization().create();
        return gson.toJson(params);
    }

    private static Map<String, String> flattenParams(Map<String, Object> params) throws InvalidRequestException {
        if (params == null) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> flatParams = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                HashMap<String, Object> flatNestedMap = new HashMap<String, Object>();
                Map nestedMap = (Map)value;
                for (Map.Entry nestedEntry : nestedMap.entrySet()) {
                    flatNestedMap.put(String.format("%s[%s]", key, nestedEntry.getKey()), nestedEntry.getValue());
                }
                flatParams.putAll(APIResource.flattenParams(flatNestedMap));
                continue;
            }
            if (value instanceof ArrayList) {
                ArrayList ar = (ArrayList)value;
                HashMap<String, Object> flatNestedMap = new HashMap<String, Object>();
                int size = ar.size();
                for (int i = 0; i < size; ++i) {
                    flatNestedMap.put(String.format("%s[%d]", key, i), ar.get(i));
                }
                flatParams.putAll(APIResource.flattenParams(flatNestedMap));
                continue;
            }
            if ("".equals(value)) {
                throw new InvalidRequestException("You cannot set '" + key + "' to an empty string. We interpret empty strings as null in requests. You may set '" + key + "' to null to delete the property.", key, null);
            }
            if (value == null) {
                flatParams.put(key, "");
                continue;
            }
            flatParams.put(key, value.toString());
        }
        return flatParams;
    }

    private static String getResponseBody(InputStream responseStream) throws IOException {
        String rBody = new Scanner(responseStream, CHARSET).useDelimiter("\\A").next();
        responseStream.close();
        return rBody;
    }

    private static PingppResponse makeURLConnectionRequest(RequestMethod method, String url, String query, String apiKey) throws APIConnectionException {
        HttpURLConnection conn = null;
        try {
            switch (method) {
                case GET: {
                    conn = APIResource.createGetConnection(url, query, apiKey);
                    break;
                }
                case POST: {
                    conn = APIResource.createPostConnection(url, query, apiKey);
                    break;
                }
                case DELETE: {
                    conn = APIResource.createDeleteConnection(url, query, apiKey);
                    break;
                }
                case PUT: {
                    conn = APIResource.createPutConnection(url, query, apiKey);
                    break;
                }
                default: {
                    throw new APIConnectionException(String.format("Unrecognized HTTP method %s. ", new Object[]{method}));
                }
            }
            int rCode = conn.getResponseCode();
            String rBody = null;
            rBody = rCode >= 200 && rCode < 300 ? APIResource.getResponseBody(conn.getInputStream()) : APIResource.getResponseBody(conn.getErrorStream());
            Map<String, List<String>> headers = conn.getHeaderFields();
            PingppResponse pingppResponse = new PingppResponse(rCode, rBody, headers);
            return pingppResponse;
        }
        catch (IOException e) {
            throw new APIConnectionException(String.format("IOException during API request to Pingpp (%s): %s Please check your internet connection and try again. If this problem persists,you should check Pingpp's service status at https://pingxx.com/status.", Pingpp.getApiBase(), e.getMessage()), e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    protected static <T> T request(RequestMethod method, String url, Map<String, Object> params, Class<T> clazz) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException, ChannelException, RateLimitException {
        return APIResource.request(method, url, null, params, clazz);
    }

    protected static <T> T request(RequestMethod method, String url, String apiKey, Map<String, Object> params, Class<T> clazz) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException, ChannelException, RateLimitException {
        String string = apiKey = apiKey != null ? apiKey : Pingpp.apiKey;
        if (apiKey == null || apiKey.length() == 0) {
            throw new AuthenticationException("No API key provided. (HINT: set your API key using 'Pingpp.apiKey = <API-KEY>'. You can generate API keys from the Pingpp web interface. See https://pingxx.com for details.");
        }
        String query = null;
        switch (method) {
            case GET: 
            case DELETE: {
                try {
                    query = APIResource.createQuery(params);
                    break;
                }
                catch (UnsupportedEncodingException e) {
                    throw new InvalidRequestException("Unable to encode parameters to UTF-8", null, e);
                }
            }
            case POST: 
            case PUT: {
                query = APIResource.createJSONString(params);
            }
        }
        int retryCount = 0;
        while (true) {
            try {
                PingppResponse response = APIResource.makeURLConnectionRequest(method, url, query, apiKey);
                if (Pingpp.DEBUG.booleanValue()) {
                    System.out.println(APIResource.getGson().toJson((Object)response));
                }
                int rCode = response.getResponseCode();
                String rBody = response.getResponseBody();
                if (rCode < 200 || rCode >= 300) {
                    APIResource.handleAPIError(rBody, rCode);
                }
                return (T)APIResource.getGson().fromJson(rBody, clazz);
            }
            catch (ClassCastException ce) {
                throw ce;
            }
            catch (ConnectException e) {
                if (retryCount < RETRY_MAX) {
                    ++retryCount;
                    continue;
                }
                throw new APIConnectionException(e.getMessage(), e);
            }
            break;
        }
    }

    private static void handleAPIError(String rBody, int rCode) throws InvalidRequestException, AuthenticationException, APIException, ChannelException, RateLimitException, ConnectException {
        Error error = null;
        try {
            error = ((ErrorContainer)APIResource.getGson().fromJson(rBody, ErrorContainer.class)).error;
        }
        catch (JsonSyntaxException e) {
            error = new Error();
            error.message = rBody;
            error.code = String.valueOf(rCode);
        }
        switch (rCode) {
            case 400: {
                throw new InvalidRequestException(error.toString(), error.param, null);
            }
            case 404: {
                throw new InvalidRequestException(error.toString(), error.param, null);
            }
            case 403: 
            case 429: {
                throw new RateLimitException(error.toString(), null);
            }
            case 402: {
                throw new ChannelException(error.toString(), error.param, null);
            }
            case 401: {
                throw new AuthenticationException(error.toString());
            }
            case 502: {
                throw new ConnectException(error.toString());
            }
        }
        throw new APIException(error.toString(), null);
    }

    private static String generateSign(String data) throws IOException {
        if (Pingpp.privateKey == null) {
            if (Pingpp.privateKeyPath == null) {
                return null;
            }
            FileInputStream inputStream = new FileInputStream(Pingpp.privateKeyPath);
            byte[] keyBytes = new byte[inputStream.available()];
            inputStream.read(keyBytes);
            inputStream.close();
            Pingpp.privateKey = new String(keyBytes, CHARSET);
        }
        return PingppSignature.sign(data, Pingpp.privateKey, CHARSET);
    }

    private static String currentTimeString() {
        Integer requestTime = (int)(System.currentTimeMillis() / 1000L);
        return requestTime.toString();
    }

    private static String getRequestURIFromURL(URL url) {
        String path = url.getPath();
        String query = url.getQuery();
        if (query == null) {
            return path;
        }
        return path + "?" + query;
    }

    private static class Error {
        String type;
        String message;
        String code;
        String param;

        private Error() {
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (null != this.type && !this.type.isEmpty()) {
                sb.append("Error type: " + this.type + "\n");
            }
            if (null != this.message && !this.message.isEmpty()) {
                sb.append("\t Error message: " + this.message + "\n");
            }
            if (null != this.code && !this.code.isEmpty()) {
                sb.append("\t Error code: " + this.code + "\n");
            }
            return sb.toString();
        }
    }

    private static class ErrorContainer {
        private Error error;

        private ErrorContainer() {
        }
    }

    protected static enum RequestMethod {
        GET,
        POST,
        DELETE,
        PUT;

    }
}

