/*
 * Decompiled with CFR 0.152.
 */
package com.pingplusplus.util;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;

public class WxpubOAuth {
    public static final String CHARSET = "UTF-8";

    public static String getOpenId(String string, String string2, String string3) throws UnsupportedEncodingException {
        String string4 = WxpubOAuth.createOauthUrlForOpenid(string, string2, string3);
        String string5 = WxpubOAuth.httpGet(string4);
        OAuthResult oAuthResult = (OAuthResult)new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create().fromJson(string5, OAuthResult.class);
        return oAuthResult.getOpenid();
    }

    public static String createOauthUrlForCode(String string, String string2, boolean bl) throws UnsupportedEncodingException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("https://open.weixin.qq.com/connect/oauth2/authorize?");
        stringBuilder.append("appid=").append(string);
        stringBuilder.append("&redirect_uri=").append(URLEncoder.encode(string2, CHARSET));
        stringBuilder.append("&response_type=code");
        stringBuilder.append("&scope=").append(bl ? "snsapi_userinfo" : "snsapi_base");
        stringBuilder.append("&state=pingpp");
        stringBuilder.append("#wechat_redirect");
        return stringBuilder.toString();
    }

    private static String createOauthUrlForOpenid(String string, String string2, String string3) throws UnsupportedEncodingException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("appid", string);
        hashMap.put("secret", string2);
        hashMap.put("code", string3);
        hashMap.put("grant_type", "authorization_code");
        String string4 = WxpubOAuth.httpBuildQuery(hashMap);
        return "https://api.weixin.qq.com/sns/oauth2/access_token?" + string4;
    }

    private static String httpBuildQuery(Map<String, String> map) throws UnsupportedEncodingException {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('&');
            }
            stringBuilder.append(URLEncoder.encode(entry.getKey(), CHARSET)).append('=').append(URLEncoder.encode(entry.getValue(), CHARSET));
        }
        return stringBuilder.toString();
    }

    private static String httpGet(String string) {
        String string2 = "";
        try {
            String string3;
            URL uRL = new URL(string);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("GET");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
            while ((string3 = bufferedReader.readLine()) != null) {
                string2 = string2 + string3;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    public static String getJsapiTicket(String string, String string2) throws UnsupportedEncodingException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("appid", string);
        hashMap.put("secret", string2);
        hashMap.put("grant_type", "client_credential");
        String string3 = WxpubOAuth.httpBuildQuery(hashMap);
        String string4 = "https://api.weixin.qq.com/cgi-bin/token?" + string3;
        String string5 = WxpubOAuth.httpGet(string4);
        JsonParser jsonParser = new JsonParser();
        JsonObject jsonObject = jsonParser.parse(string5).getAsJsonObject();
        if (jsonObject.has("errcode")) {
            return jsonObject.toString();
        }
        hashMap.clear();
        hashMap.put("access_token", jsonObject.get("access_token").getAsString());
        hashMap.put("type", "jsapi");
        string3 = WxpubOAuth.httpBuildQuery(hashMap);
        String string6 = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?" + string3;
        string5 = WxpubOAuth.httpGet(string6);
        JsonObject jsonObject2 = jsonParser.parse(string5).getAsJsonObject();
        return jsonObject2.get("ticket").getAsString();
    }

    public static String getSignature(String string, String string2, String string3) {
        if (null == string || null == string2 || string.isEmpty() || string2.isEmpty()) {
            return null;
        }
        JsonParser jsonParser = new JsonParser();
        JsonObject jsonObject = jsonParser.parse(string).getAsJsonObject();
        if (!jsonObject.has("credential")) {
            return null;
        }
        JsonObject jsonObject2 = jsonObject.get("credential").getAsJsonObject();
        if (!jsonObject2.has("wx_pub")) {
            return null;
        }
        JsonObject jsonObject3 = jsonObject2.get("wx_pub").getAsJsonObject();
        String string4 = "";
        String string5 = "jsapi_ticket=" + string2 + "&noncestr=" + jsonObject3.get("nonceStr").getAsString() + "&timestamp=" + jsonObject3.get("timeStamp").getAsString() + "&url=" + string3;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.reset();
            messageDigest.update(string5.getBytes(CHARSET));
            string4 = WxpubOAuth.byteToHex(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return string4;
    }

    private static String byteToHex(byte[] byArray) {
        Formatter formatter = new Formatter();
        for (byte by : byArray) {
            formatter.format("%02x", by);
        }
        String string = formatter.toString();
        formatter.close();
        return string;
    }

    class OAuthResult {
        String accessToken;
        int expiresIn;
        String refreshToken;
        String openid;
        String scope;

        OAuthResult() {
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public int getExpiresIn() {
            return this.expiresIn;
        }

        public String getRefreshToken() {
            return this.refreshToken;
        }

        public String getOpenid() {
            return this.openid;
        }

        public String getScope() {
            return this.scope;
        }
    }
}

