/*
 * Decompiled with CFR 0.152.
 */
package com.pingplusplus.net;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.pingplusplus.model.App;
import com.pingplusplus.model.Charge;
import com.pingplusplus.model.ChargeRefundCollection;
import com.pingplusplus.net.ChargeRefundCollectionDeserializer;
import java.lang.reflect.Type;

public class ChargeDeserializer
implements JsonDeserializer<Charge> {
    public Charge deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonObject chargeJson = jsonElement.getAsJsonObject();
        if (null != chargeJson.getAsJsonObject("credential")) {
            Long timeStamp;
            JsonObject wx;
            JsonObject credentialJson = chargeJson.getAsJsonObject("credential");
            if (null != credentialJson.getAsJsonObject("wx")) {
                wx = credentialJson.getAsJsonObject("wx");
                timeStamp = wx.get("timeStamp").getAsLong();
                wx.addProperty("timeStamp", "" + timeStamp);
            } else if (null != credentialJson.getAsJsonObject("wx_pub")) {
                wx = credentialJson.getAsJsonObject("wx_pub");
                timeStamp = wx.get("timeStamp").getAsLong();
                wx.addProperty("timeStamp", "" + timeStamp);
            } else if (null != credentialJson.getAsJsonObject("bfb")) {
                JsonObject bfb = credentialJson.getAsJsonObject("bfb");
                Long total_amount = bfb.get("total_amount").getAsLong();
                bfb.addProperty("total_amount", total_amount + "");
            }
        }
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter(ChargeRefundCollection.class, (Object)new ChargeRefundCollectionDeserializer()).create();
        JsonElement appElement = chargeJson.get("app");
        Charge charge = (Charge)gson.fromJson(jsonElement, Charge.class);
        if (null != appElement && appElement.isJsonObject()) {
            App app = (App)gson.fromJson(appElement, App.class);
            charge.setApp(app);
        }
        return charge;
    }
}

