/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.yrtietfyangpush.rev20161028.yrtietfyangpush.updatepolicy.updatetrigger;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v1.yrtietfyangtypes.rev20130715.yrtietfyangtypes.Timeticks;
import org.onosproject.yang.gen.v11.yrtietfyangpush.rev20161028.yrtietfyangpush.ChangeType;
import org.onosproject.yang.gen.v11.yrtietfyangpush.rev20161028.yrtietfyangpush.updatepolicy.UpdateTrigger;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of onChange.
 */
public interface OnChange extends UpdateTrigger, Augmentable  {

    /**
     * Identify the leaf of OnChange.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents noSynchOnStart.
         */
        NOSYNCHONSTART(1),
        /**
         * Represents dampeningPeriod.
         */
        DAMPENINGPERIOD(2),
        /**
         * Represents excludedChange.
         */
        EXCLUDEDCHANGE(3);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute noSynchOnStart.
     *
     * @return noSynchOnStart value of noSynchOnStart
     */
    boolean noSynchOnStart();

    /**
     * Returns the attribute dampeningPeriod.
     *
     * @return dampeningPeriod value of dampeningPeriod
     */
    Timeticks dampeningPeriod();

    /**
     * Returns the attribute excludedChange.
     *
     * @return excludedChange list of excludedChange
     */
    List<ChangeType> excludedChange();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute noSynchOnStart.
     *
     * @param noSynchOnStart value of noSynchOnStart
     */
    void noSynchOnStart(boolean noSynchOnStart);

    /**
     * Sets the attribute dampeningPeriod.
     *
     * @param dampeningPeriod value of dampeningPeriod
     */
    void dampeningPeriod(Timeticks dampeningPeriod);

    /**
     * Sets the attribute excludedChange.
     *
     * @param excludedChange list of excludedChange
     */
    void excludedChange(List<ChangeType> excludedChange);

    /**
     * Adds to the list of excludedChange.
     *
     * @param addTo value of excludedChange
     */
    void addToExcludedChange(ChangeType addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}