/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.yrtietfyangpush.rev20161028.yrtietfyangpush;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications.SubscriptionId;
import org.onosproject.yang.gen.v1.yrtietfyangtypes.rev20130715.yrtietfyangtypes.DateAndTime;
import org.onosproject.yang.gen.v11.yrtietfyangpush.rev20161028.yrtietfyangpush.pushchangeupdate.DatastoreChanges;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of pushChangeUpdate.
 */
public interface PushChangeUpdate extends Augmentable  {

    /**
     * Identify the leaf of PushChangeUpdate.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents subscriptionId.
         */
        SUBSCRIPTIONID(1),
        /**
         * Represents timeOfUpdate.
         */
        TIMEOFUPDATE(2),
        /**
         * Represents updatesNotSent.
         */
        UPDATESNOTSENT(3),
        /**
         * Represents datastoreChangesString.
         */
        DATASTORECHANGESSTRING(4);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute subscriptionId.
     *
     * @return subscriptionId value of subscriptionId
     */
    SubscriptionId subscriptionId();

    /**
     * Returns the attribute timeOfUpdate.
     *
     * @return timeOfUpdate value of timeOfUpdate
     */
    DateAndTime timeOfUpdate();

    /**
     * Returns the attribute updatesNotSent.
     *
     * @return updatesNotSent value of updatesNotSent
     */
    boolean updatesNotSent();

    /**
     * Returns the attribute datastoreChangesString.
     *
     * @return datastoreChangesString value of datastoreChangesString
     */
    String datastoreChangesString();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute datastoreChanges.
     *
     * @return datastoreChanges value of datastoreChanges
     */
    DatastoreChanges datastoreChanges();

    /**
     * Sets the attribute subscriptionId.
     *
     * @param subscriptionId value of subscriptionId
     */
    void subscriptionId(SubscriptionId subscriptionId);

    /**
     * Sets the attribute timeOfUpdate.
     *
     * @param timeOfUpdate value of timeOfUpdate
     */
    void timeOfUpdate(DateAndTime timeOfUpdate);

    /**
     * Sets the attribute updatesNotSent.
     *
     * @param updatesNotSent value of updatesNotSent
     */
    void updatesNotSent(boolean updatesNotSent);

    /**
     * Sets the attribute datastoreChangesString.
     *
     * @param datastoreChangesString value of datastoreChangesString
     */
    void datastoreChangesString(String datastoreChangesString);

    /**
     * Sets the attribute datastoreChanges.
     *
     * @param datastoreChanges value of datastoreChanges
     */
    void datastoreChanges(DatastoreChanges datastoreChanges);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}