/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.yrtietfyangpush.rev20161028.yrtietfyangpush;

import org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications.Transport;

/**
 * Represents the implementation of http2.
 */
public abstract class Http2 extends Transport {

    /**
     * Returns the attribute http2.
     *
     * @return http2 value of http2
     */
    public static String http2ToString() {
        return "http2";
    }

    /**
     * Returns the object of http2 fromString input String http2.
     *
     * @param valInString value of input String
     * @return http2
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("http2")) {
            return Http2.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}