/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.yrtietfyangpatch.rev20170222.yrtietfyangpatch.yangpatchstatus.yangpatchstatus.editstatus;

import java.util.BitSet;
import org.onosproject.yang.gen.v11.yrtietfyangpatch.rev20170222.yrtietfyangpatch.yangpatchstatus.yangpatchstatus.editstatus.edit.EditStatusChoice;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of edit.
 */
public interface Edit extends Augmentable  {

    /**
     * Identify the leaf of Edit.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents editId.
         */
        EDITID(1);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute editId.
     *
     * @return editId value of editId
     */
    String editId();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute editStatusChoice.
     *
     * @return editStatusChoice value of editStatusChoice
     */
    EditStatusChoice editStatusChoice();

    /**
     * Sets the attribute editId.
     *
     * @param editId value of editId
     */
    void editId(String editId);

    /**
     * Sets the attribute editStatusChoice.
     *
     * @param editStatusChoice value of editStatusChoice
     */
    void editStatusChoice(EditStatusChoice editStatusChoice);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}