/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.yrtietfyangpatch.rev20170222.yrtietfyangpatch.yangpatch.yangpatch.edit;

/**
 * Represents ENUM data of whereEnum.
 */
public enum WhereEnum {

    /**
     * Represents before.
     */
    BEFORE(0, "before"),

    /**
     * Represents after.
     */
    AFTER(1, "after"),

    /**
     * Represents first.
     */
    FIRST(2, "first"),

    /**
     * Represents last.
     */
    LAST(3, "last");

    private int whereEnum;
    private String schemaName;

    /**
     * Creates an instance of whereEnum.
     *
     * @param whereEnum value of whereEnum
     */
     WhereEnum(int whereEnum, String schemaName) {
        this.whereEnum = whereEnum;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of whereEnum for.
     *
     * @param value value of whereEnum for
     * @return whereEnum for
     */
    public static WhereEnum of(int value) {
        switch (value) {
            case 0:
                return WhereEnum.BEFORE;
            case 1:
                return WhereEnum.AFTER;
            case 2:
                return WhereEnum.FIRST;
            case 3:
                return WhereEnum.LAST;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of whereEnum for.
     *
     * @param value value of whereEnum for
     * @return whereEnum for
     */
    public static WhereEnum of(String value) {
        switch (value) {
            case "before":
                return WhereEnum.BEFORE;
            case "after":
                return WhereEnum.AFTER;
            case "first":
                return WhereEnum.FIRST;
            case "last":
                return WhereEnum.LAST;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute whereEnum.
     *
     * @return whereEnum value of whereEnum
     */
    public int whereEnum() {
        return whereEnum;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
