/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.yrtietfyangpatch.rev20170222.yrtietfyangpatch.yangpatch.yangpatch;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v11.yrtietfyangpatch.rev20170222.yrtietfyangpatch.TargetResourceOffset;
import org.onosproject.yang.gen.v11.yrtietfyangpatch.rev20170222.yrtietfyangpatch.yangpatch.yangpatch.edit.OperationEnum;
import org.onosproject.yang.gen.v11.yrtietfyangpatch.rev20170222.yrtietfyangpatch.yangpatch.yangpatch.edit.Value;
import org.onosproject.yang.gen.v11.yrtietfyangpatch.rev20170222.yrtietfyangpatch.yangpatch.yangpatch.edit.WhereEnum;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of edit.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultEdit extends InnerModelObject 
        implements Edit, MultiInstanceObject<EditKeys> {
    protected String editId;
    protected OperationEnum operation;
    protected TargetResourceOffset target;
    protected TargetResourceOffset point;
    protected WhereEnum where;
    protected BitSet valueLeafFlags = new BitSet();
    protected Value value;

    @Override
    public String editId() {
        return editId;
    }

    @Override
    public OperationEnum operation() {
        return operation;
    }

    @Override
    public TargetResourceOffset target() {
        return target;
    }

    @Override
    public TargetResourceOffset point() {
        return point;
    }

    @Override
    public WhereEnum where() {
        return where;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public Value value() {
        return value;
    }

    @Override
    public void editId(String editId) {
        valueLeafFlags.set(LeafIdentifier.EDITID.getLeafIndex());
        this.editId = editId;
    }

    @Override
    public void operation(OperationEnum operation) {
        valueLeafFlags.set(LeafIdentifier.OPERATION.getLeafIndex());
        this.operation = operation;
    }

    @Override
    public void target(TargetResourceOffset target) {
        valueLeafFlags.set(LeafIdentifier.TARGET.getLeafIndex());
        this.target = target;
    }

    @Override
    public void point(TargetResourceOffset point) {
        valueLeafFlags.set(LeafIdentifier.POINT.getLeafIndex());
        this.point = point;
    }

    @Override
    public void where(WhereEnum where) {
        valueLeafFlags.set(LeafIdentifier.WHERE.getLeafIndex());
        this.where = where;
    }

    @Override
    public void value(Value value) {
        this.value = value;
    }

    @Override
    public int hashCode() {
        return Objects.hash(editId, operation, target, point, where, valueLeafFlags, value);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultEdit) {
            DefaultEdit other = (DefaultEdit) obj;
            return
                Objects.deepEquals(editId, other.editId) &&
                Objects.deepEquals(operation, other.operation) &&
                Objects.deepEquals(target, other.target) &&
                Objects.deepEquals(point, other.point) &&
                Objects.deepEquals(where, other.where) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(value, other.value);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("editId=" + editId)
            .add("operation=" + operation)
            .add("target=" + target)
            .add("point=" + point)
            .add("where=" + where)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("value=" + value)
            .toString();
    }


    /**
     * Creates an instance of defaultEdit.
     */
    public DefaultEdit() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}