/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.yrtietfyangpatch.rev20170222.yrtietfyangpatch.yangpatch;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v11.yrtietfyangpatch.rev20170222.yrtietfyangpatch.yangpatch.yangpatch.Edit;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of yangPatch.
 */
public interface YangPatch extends Augmentable  {

    /**
     * Identify the leaf of YangPatch.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents patchId.
         */
        PATCHID(1),
        /**
         * Represents comment.
         */
        COMMENT(2);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute patchId.
     *
     * @return patchId value of patchId
     */
    String patchId();

    /**
     * Returns the attribute comment.
     *
     * @return comment value of comment
     */
    String comment();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute edit.
     *
     * @return edit list of edit
     */
    List<Edit> edit();

    /**
     * Sets the attribute patchId.
     *
     * @param patchId value of patchId
     */
    void patchId(String patchId);

    /**
     * Sets the attribute comment.
     *
     * @param comment value of comment
     */
    void comment(String comment);

    /**
     * Sets the attribute edit.
     *
     * @param edit list of edit
     */
    void edit(List<Edit> edit);

    /**
     * Adds to the list of edit.
     *
     * @param addTo value of edit
     */
    void addToEdit(Edit addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}