/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.yrtietfrestconf.rev20170126.yrtietfrestconf.errors;

import java.util.List;
import org.onosproject.yang.gen.v11.yrtietfrestconf.rev20170126.yrtietfrestconf.errors.errors.Error;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of errors.
 */
public interface Errors extends Augmentable  {

    /**
     * Returns the attribute error.
     *
     * @return error list of error
     */
    List<Error> error();

    /**
     * Sets the attribute error.
     *
     * @param error list of error
     */
    void error(List<Error> error);

    /**
     * Adds to the list of error.
     *
     * @param addTo value of error
     */
    void addToError(Error addTo);

}