/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.yrtietfotntunnel.rev20170311.yrtietfotntunnel.te.tunnels.tunnel.config;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtietftransporttypes.rev20161025.yrtietftransporttypes.ClientSignal;
import org.onosproject.yang.gen.v1.yrtietftransporttypes.rev20161025.yrtietftransporttypes.TributarySlotGranularity;
import org.onosproject.yang.gen.v11.yrtietfotntunnel.rev20170311.yrtietfotntunnel.otntunnelendpoint.DstTributarySlots;
import org.onosproject.yang.gen.v11.yrtietfotntunnel.rev20170311.yrtietfotntunnel.otntunnelendpoint.PayloadTreatmentEnum;
import org.onosproject.yang.gen.v11.yrtietfotntunnel.rev20170311.yrtietfotntunnel.otntunnelendpoint.SrcTributarySlots;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of augmentedTeConfig.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultAugmentedTeConfig extends InnerModelObject implements AugmentedTeConfig {
    protected PayloadTreatmentEnum payloadTreatment;
    protected Class<? extends ClientSignal> srcClientSignal;
    protected int srcTpn;
    protected Class<? extends TributarySlotGranularity> srcTsg;
    protected int srcTributarySlotCount;
    protected Class<? extends ClientSignal> dstClientSignal;
    protected int dstTpn;
    protected Class<? extends TributarySlotGranularity> dstTsg;
    protected int dstTributarySlotCount;
    protected BitSet valueLeafFlags = new BitSet();
    protected SrcTributarySlots srcTributarySlots;
    protected DstTributarySlots dstTributarySlots;

    @Override
    public PayloadTreatmentEnum payloadTreatment() {
        return payloadTreatment;
    }

    @Override
    public Class<? extends ClientSignal> srcClientSignal() {
        return srcClientSignal;
    }

    @Override
    public int srcTpn() {
        return srcTpn;
    }

    @Override
    public Class<? extends TributarySlotGranularity> srcTsg() {
        return srcTsg;
    }

    @Override
    public int srcTributarySlotCount() {
        return srcTributarySlotCount;
    }

    @Override
    public Class<? extends ClientSignal> dstClientSignal() {
        return dstClientSignal;
    }

    @Override
    public int dstTpn() {
        return dstTpn;
    }

    @Override
    public Class<? extends TributarySlotGranularity> dstTsg() {
        return dstTsg;
    }

    @Override
    public int dstTributarySlotCount() {
        return dstTributarySlotCount;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public SrcTributarySlots srcTributarySlots() {
        return srcTributarySlots;
    }

    @Override
    public DstTributarySlots dstTributarySlots() {
        return dstTributarySlots;
    }

    @Override
    public void payloadTreatment(PayloadTreatmentEnum payloadTreatment) {
        valueLeafFlags.set(LeafIdentifier.PAYLOADTREATMENT.getLeafIndex());
        this.payloadTreatment = payloadTreatment;
    }

    @Override
    public void srcClientSignal(Class<? extends ClientSignal> srcClientSignal) {
        valueLeafFlags.set(LeafIdentifier.SRCCLIENTSIGNAL.getLeafIndex());
        this.srcClientSignal = srcClientSignal;
    }

    @Override
    public void srcTpn(int srcTpn) {
        valueLeafFlags.set(LeafIdentifier.SRCTPN.getLeafIndex());
        this.srcTpn = srcTpn;
    }

    @Override
    public void srcTsg(Class<? extends TributarySlotGranularity> srcTsg) {
        valueLeafFlags.set(LeafIdentifier.SRCTSG.getLeafIndex());
        this.srcTsg = srcTsg;
    }

    @Override
    public void srcTributarySlotCount(int srcTributarySlotCount) {
        valueLeafFlags.set(LeafIdentifier.SRCTRIBUTARYSLOTCOUNT.getLeafIndex());
        this.srcTributarySlotCount = srcTributarySlotCount;
    }

    @Override
    public void dstClientSignal(Class<? extends ClientSignal> dstClientSignal) {
        valueLeafFlags.set(LeafIdentifier.DSTCLIENTSIGNAL.getLeafIndex());
        this.dstClientSignal = dstClientSignal;
    }

    @Override
    public void dstTpn(int dstTpn) {
        valueLeafFlags.set(LeafIdentifier.DSTTPN.getLeafIndex());
        this.dstTpn = dstTpn;
    }

    @Override
    public void dstTsg(Class<? extends TributarySlotGranularity> dstTsg) {
        valueLeafFlags.set(LeafIdentifier.DSTTSG.getLeafIndex());
        this.dstTsg = dstTsg;
    }

    @Override
    public void dstTributarySlotCount(int dstTributarySlotCount) {
        valueLeafFlags.set(LeafIdentifier.DSTTRIBUTARYSLOTCOUNT.getLeafIndex());
        this.dstTributarySlotCount = dstTributarySlotCount;
    }

    @Override
    public void srcTributarySlots(SrcTributarySlots srcTributarySlots) {
        this.srcTributarySlots = srcTributarySlots;
    }

    @Override
    public void dstTributarySlots(DstTributarySlots dstTributarySlots) {
        this.dstTributarySlots = dstTributarySlots;
    }

    @Override
    public int hashCode() {
        return Objects.hash(payloadTreatment, srcClientSignal, srcTpn, srcTsg, srcTributarySlotCount, dstClientSignal, dstTpn, dstTsg, dstTributarySlotCount, valueLeafFlags, srcTributarySlots, dstTributarySlots);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultAugmentedTeConfig) {
            DefaultAugmentedTeConfig other = (DefaultAugmentedTeConfig) obj;
            return
                Objects.deepEquals(payloadTreatment, other.payloadTreatment) &&
                Objects.deepEquals(srcClientSignal, other.srcClientSignal) &&
                Objects.deepEquals(srcTpn, other.srcTpn) &&
                Objects.deepEquals(srcTsg, other.srcTsg) &&
                Objects.deepEquals(srcTributarySlotCount, other.srcTributarySlotCount) &&
                Objects.deepEquals(dstClientSignal, other.dstClientSignal) &&
                Objects.deepEquals(dstTpn, other.dstTpn) &&
                Objects.deepEquals(dstTsg, other.dstTsg) &&
                Objects.deepEquals(dstTributarySlotCount, other.dstTributarySlotCount) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(srcTributarySlots, other.srcTributarySlots) &&
                Objects.deepEquals(dstTributarySlots, other.dstTributarySlots);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("payloadTreatment=" + payloadTreatment)
            .add("srcClientSignal=" + srcClientSignal)
            .add("srcTpn=" + srcTpn)
            .add("srcTsg=" + srcTsg)
            .add("srcTributarySlotCount=" + srcTributarySlotCount)
            .add("dstClientSignal=" + dstClientSignal)
            .add("dstTpn=" + dstTpn)
            .add("dstTsg=" + dstTsg)
            .add("dstTributarySlotCount=" + dstTributarySlotCount)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("srcTributarySlots=" + srcTributarySlots)
            .add("dstTributarySlots=" + dstTributarySlots)
            .toString();
    }


    /**
     * Creates an instance of defaultAugmentedTeConfig.
     */
    public DefaultAugmentedTeConfig() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}