/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.yrtietfotntunnel.rev20170311.yrtietfotntunnel.te.tunnels.tunnel.config;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.yrtietftransporttypes.rev20161025.yrtietftransporttypes.ClientSignal;
import org.onosproject.yang.gen.v1.yrtietftransporttypes.rev20161025.yrtietftransporttypes.TributarySlotGranularity;
import org.onosproject.yang.gen.v11.yrtietfotntunnel.rev20170311.yrtietfotntunnel.otntunnelendpoint.DstTributarySlots;
import org.onosproject.yang.gen.v11.yrtietfotntunnel.rev20170311.yrtietfotntunnel.otntunnelendpoint.PayloadTreatmentEnum;
import org.onosproject.yang.gen.v11.yrtietfotntunnel.rev20170311.yrtietfotntunnel.otntunnelendpoint.SrcTributarySlots;

/**
 * Abstraction of an entity which represents the functionality of augmentedTeConfig.
 */
public interface AugmentedTeConfig {

    /**
     * Identify the leaf of AugmentedTeConfig.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents payloadTreatment.
         */
        PAYLOADTREATMENT(1),
        /**
         * Represents srcClientSignal.
         */
        SRCCLIENTSIGNAL(2),
        /**
         * Represents srcTpn.
         */
        SRCTPN(3),
        /**
         * Represents srcTsg.
         */
        SRCTSG(4),
        /**
         * Represents srcTributarySlotCount.
         */
        SRCTRIBUTARYSLOTCOUNT(5),
        /**
         * Represents dstClientSignal.
         */
        DSTCLIENTSIGNAL(6),
        /**
         * Represents dstTpn.
         */
        DSTTPN(7),
        /**
         * Represents dstTsg.
         */
        DSTTSG(8),
        /**
         * Represents dstTributarySlotCount.
         */
        DSTTRIBUTARYSLOTCOUNT(9);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute payloadTreatment.
     *
     * @return payloadTreatment value of payloadTreatment
     */
    PayloadTreatmentEnum payloadTreatment();

    /**
     * Returns the attribute srcClientSignal.
     *
     * @return srcClientSignal value of srcClientSignal
     */
    Class<? extends ClientSignal> srcClientSignal();

    /**
     * Returns the attribute srcTpn.
     *
     * @return srcTpn value of srcTpn
     */
    int srcTpn();

    /**
     * Returns the attribute srcTsg.
     *
     * @return srcTsg value of srcTsg
     */
    Class<? extends TributarySlotGranularity> srcTsg();

    /**
     * Returns the attribute srcTributarySlotCount.
     *
     * @return srcTributarySlotCount value of srcTributarySlotCount
     */
    int srcTributarySlotCount();

    /**
     * Returns the attribute dstClientSignal.
     *
     * @return dstClientSignal value of dstClientSignal
     */
    Class<? extends ClientSignal> dstClientSignal();

    /**
     * Returns the attribute dstTpn.
     *
     * @return dstTpn value of dstTpn
     */
    int dstTpn();

    /**
     * Returns the attribute dstTsg.
     *
     * @return dstTsg value of dstTsg
     */
    Class<? extends TributarySlotGranularity> dstTsg();

    /**
     * Returns the attribute dstTributarySlotCount.
     *
     * @return dstTributarySlotCount value of dstTributarySlotCount
     */
    int dstTributarySlotCount();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute srcTributarySlots.
     *
     * @return srcTributarySlots value of srcTributarySlots
     */
    SrcTributarySlots srcTributarySlots();

    /**
     * Returns the attribute dstTributarySlots.
     *
     * @return dstTributarySlots value of dstTributarySlots
     */
    DstTributarySlots dstTributarySlots();

    /**
     * Sets the attribute payloadTreatment.
     *
     * @param payloadTreatment value of payloadTreatment
     */
    void payloadTreatment(PayloadTreatmentEnum payloadTreatment);

    /**
     * Sets the attribute srcClientSignal.
     *
     * @param srcClientSignal value of srcClientSignal
     */
    void srcClientSignal(Class<? extends ClientSignal> srcClientSignal);

    /**
     * Sets the attribute srcTpn.
     *
     * @param srcTpn value of srcTpn
     */
    void srcTpn(int srcTpn);

    /**
     * Sets the attribute srcTsg.
     *
     * @param srcTsg value of srcTsg
     */
    void srcTsg(Class<? extends TributarySlotGranularity> srcTsg);

    /**
     * Sets the attribute srcTributarySlotCount.
     *
     * @param srcTributarySlotCount value of srcTributarySlotCount
     */
    void srcTributarySlotCount(int srcTributarySlotCount);

    /**
     * Sets the attribute dstClientSignal.
     *
     * @param dstClientSignal value of dstClientSignal
     */
    void dstClientSignal(Class<? extends ClientSignal> dstClientSignal);

    /**
     * Sets the attribute dstTpn.
     *
     * @param dstTpn value of dstTpn
     */
    void dstTpn(int dstTpn);

    /**
     * Sets the attribute dstTsg.
     *
     * @param dstTsg value of dstTsg
     */
    void dstTsg(Class<? extends TributarySlotGranularity> dstTsg);

    /**
     * Sets the attribute dstTributarySlotCount.
     *
     * @param dstTributarySlotCount value of dstTributarySlotCount
     */
    void dstTributarySlotCount(int dstTributarySlotCount);

    /**
     * Sets the attribute srcTributarySlots.
     *
     * @param srcTributarySlots value of srcTributarySlots
     */
    void srcTributarySlots(SrcTributarySlots srcTributarySlots);

    /**
     * Sets the attribute dstTributarySlots.
     *
     * @param dstTributarySlots value of dstTributarySlots
     */
    void dstTributarySlots(DstTributarySlots dstTributarySlots);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}