/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.yrtietfotntunnel.rev20170311.yrtietfotntunnel.p2ppathero;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.RouteUsageType;
import org.onosproject.yang.gen.v11.yrtietfotntunnel.rev20170311.yrtietfotntunnel.p2ppathero.explicitrouteobjects.ExplicitRouteObject;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of explicitRouteObjects.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultExplicitRouteObjects extends InnerModelObject implements ExplicitRouteObjects {
    protected Class<? extends RouteUsageType> explicitRouteUsage;
    protected BitSet valueLeafFlags = new BitSet();
    protected List<ExplicitRouteObject> explicitRouteObject;

    @Override
    public Class<? extends RouteUsageType> explicitRouteUsage() {
        return explicitRouteUsage;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public List<ExplicitRouteObject> explicitRouteObject() {
        return explicitRouteObject;
    }

    @Override
    public void explicitRouteUsage(Class<? extends RouteUsageType> explicitRouteUsage) {
        valueLeafFlags.set(LeafIdentifier.EXPLICITROUTEUSAGE.getLeafIndex());
        this.explicitRouteUsage = explicitRouteUsage;
    }

    @Override
    public void explicitRouteObject(List<ExplicitRouteObject> explicitRouteObject) {
        this.explicitRouteObject = explicitRouteObject;
    }

    @Override
    public void addToExplicitRouteObject(ExplicitRouteObject addTo) {
        if (explicitRouteObject == null) {
            explicitRouteObject = new ArrayList<>();
        }
        explicitRouteObject.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(explicitRouteUsage, valueLeafFlags, explicitRouteObject);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultExplicitRouteObjects) {
            DefaultExplicitRouteObjects other = (DefaultExplicitRouteObjects) obj;
            return
                Objects.deepEquals(explicitRouteUsage, other.explicitRouteUsage) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(explicitRouteObject, other.explicitRouteObject);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("explicitRouteUsage=" + explicitRouteUsage)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("explicitRouteObject=" + explicitRouteObject)
            .toString();
    }


    /**
     * Creates an instance of defaultExplicitRouteObjects.
     */
    public DefaultExplicitRouteObjects() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}