/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.yrtietfotntunnel.rev20170311.yrtietfotntunnel.otntetunnelpathcompute.otntetunnelpathcomputeoutput.result.p2pprimarypaths;

import java.util.BitSet;
import org.onosproject.yang.gen.v11.yrtietfotntunnel.rev20170311.yrtietfotntunnel.p2ppathero.ExplicitRouteObjects;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of p2PprimaryPath.
 */
public interface P2PprimaryPath extends Augmentable  {

    /**
     * Identify the leaf of P2PprimaryPath.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents name.
         */
        NAME(1),
        /**
         * Represents teDefaultMetric.
         */
        TEDEFAULTMETRIC(2),
        /**
         * Represents teDelayMetric.
         */
        TEDELAYMETRIC(3),
        /**
         * Represents teHopMetric.
         */
        TEHOPMETRIC(4);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute name.
     *
     * @return name value of name
     */
    String name();

    /**
     * Returns the attribute teDefaultMetric.
     *
     * @return teDefaultMetric value of teDefaultMetric
     */
    long teDefaultMetric();

    /**
     * Returns the attribute teDelayMetric.
     *
     * @return teDelayMetric value of teDelayMetric
     */
    long teDelayMetric();

    /**
     * Returns the attribute teHopMetric.
     *
     * @return teHopMetric value of teHopMetric
     */
    long teHopMetric();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute explicitRouteObjects.
     *
     * @return explicitRouteObjects value of explicitRouteObjects
     */
    ExplicitRouteObjects explicitRouteObjects();

    /**
     * Sets the attribute name.
     *
     * @param name value of name
     */
    void name(String name);

    /**
     * Sets the attribute teDefaultMetric.
     *
     * @param teDefaultMetric value of teDefaultMetric
     */
    void teDefaultMetric(long teDefaultMetric);

    /**
     * Sets the attribute teDelayMetric.
     *
     * @param teDelayMetric value of teDelayMetric
     */
    void teDelayMetric(long teDelayMetric);

    /**
     * Sets the attribute teHopMetric.
     *
     * @param teHopMetric value of teHopMetric
     */
    void teHopMetric(long teHopMetric);

    /**
     * Sets the attribute explicitRouteObjects.
     *
     * @param explicitRouteObjects value of explicitRouteObjects
     */
    void explicitRouteObjects(ExplicitRouteObjects explicitRouteObjects);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}