/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.yrtietfotntunnel.rev20170311.yrtietfotntunnel.otntetunnelpathcompute.otntetunnelpathcomputeoutput;

/**
 * Represents ENUM data of returnCodeEnum.
 */
public enum ReturnCodeEnum {

    /**
     * Represents success.
     */
    SUCCESS(0, "success"),

    /**
     * Represents aborted.
     */
    ABORTED(1, "aborted"),

    /**
     * Represents destination-not-found.
     */
    DESTINATION_NOT_FOUND(2, "destination-not-found"),

    /**
     * Represents invalid-argument.
     */
    INVALID_ARGUMENT(3, "invalid-argument"),

    /**
     * Represents no-memory.
     */
    NO_MEMORY(4, "no-memory"),

    /**
     * Represents no-path-found.
     */
    NO_PATH_FOUND(5, "no-path-found"),

    /**
     * Represents other-error.
     */
    OTHER_ERROR(6, "other-error"),

    /**
     * Represents some-path-not-found.
     */
    SOME_PATH_NOT_FOUND(7, "some-path-not-found"),

    /**
     * Represents source-not-found.
     */
    SOURCE_NOT_FOUND(8, "source-not-found"),

    /**
     * Represents topology-error.
     */
    TOPOLOGY_ERROR(9, "topology-error");

    private int returnCodeEnum;
    private String schemaName;

    /**
     * Creates an instance of returnCodeEnum.
     *
     * @param returnCodeEnum value of returnCodeEnum
     */
     ReturnCodeEnum(int returnCodeEnum, String schemaName) {
        this.returnCodeEnum = returnCodeEnum;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of returnCodeEnum for.
     *
     * @param value value of returnCodeEnum for
     * @return returnCodeEnum for
     */
    public static ReturnCodeEnum of(int value) {
        switch (value) {
            case 0:
                return ReturnCodeEnum.SUCCESS;
            case 1:
                return ReturnCodeEnum.ABORTED;
            case 2:
                return ReturnCodeEnum.DESTINATION_NOT_FOUND;
            case 3:
                return ReturnCodeEnum.INVALID_ARGUMENT;
            case 4:
                return ReturnCodeEnum.NO_MEMORY;
            case 5:
                return ReturnCodeEnum.NO_PATH_FOUND;
            case 6:
                return ReturnCodeEnum.OTHER_ERROR;
            case 7:
                return ReturnCodeEnum.SOME_PATH_NOT_FOUND;
            case 8:
                return ReturnCodeEnum.SOURCE_NOT_FOUND;
            case 9:
                return ReturnCodeEnum.TOPOLOGY_ERROR;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of returnCodeEnum for.
     *
     * @param value value of returnCodeEnum for
     * @return returnCodeEnum for
     */
    public static ReturnCodeEnum of(String value) {
        switch (value) {
            case "success":
                return ReturnCodeEnum.SUCCESS;
            case "aborted":
                return ReturnCodeEnum.ABORTED;
            case "destination-not-found":
                return ReturnCodeEnum.DESTINATION_NOT_FOUND;
            case "invalid-argument":
                return ReturnCodeEnum.INVALID_ARGUMENT;
            case "no-memory":
                return ReturnCodeEnum.NO_MEMORY;
            case "no-path-found":
                return ReturnCodeEnum.NO_PATH_FOUND;
            case "other-error":
                return ReturnCodeEnum.OTHER_ERROR;
            case "some-path-not-found":
                return ReturnCodeEnum.SOME_PATH_NOT_FOUND;
            case "source-not-found":
                return ReturnCodeEnum.SOURCE_NOT_FOUND;
            case "topology-error":
                return ReturnCodeEnum.TOPOLOGY_ERROR;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute returnCodeEnum.
     *
     * @return returnCodeEnum value of returnCodeEnum
     */
    public int returnCodeEnum() {
        return returnCodeEnum;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
