/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.yrtietfotntunnel.rev20170311.yrtietfotntunnel.otntetunnelpathcompute.otntetunnelpathcomputeoutput;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v11.yrtietfotntunnel.rev20170311.yrtietfotntunnel.otntetunnelpathcompute.otntetunnelpathcomputeoutput.result.P2PprimaryPaths;
import org.onosproject.yang.gen.v11.yrtietfotntunnel.rev20170311.yrtietfotntunnel.otntetunnelpathcompute.otntetunnelpathcomputeoutput.result.P2PsecondaryPaths;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of result.
 */
public class DefaultResult extends InnerModelObject 
        implements Result, MultiInstanceObject<ResultKeys> {
    protected short id;
    protected BitSet valueLeafFlags = new BitSet();
    protected P2PprimaryPaths p2PprimaryPaths;
    protected P2PsecondaryPaths p2PsecondaryPaths;

    @Override
    public short id() {
        return id;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public P2PprimaryPaths p2PprimaryPaths() {
        return p2PprimaryPaths;
    }

    @Override
    public P2PsecondaryPaths p2PsecondaryPaths() {
        return p2PsecondaryPaths;
    }

    @Override
    public void id(short id) {
        valueLeafFlags.set(LeafIdentifier.ID.getLeafIndex());
        this.id = id;
    }

    @Override
    public void p2PprimaryPaths(P2PprimaryPaths p2PprimaryPaths) {
        this.p2PprimaryPaths = p2PprimaryPaths;
    }

    @Override
    public void p2PsecondaryPaths(P2PsecondaryPaths p2PsecondaryPaths) {
        this.p2PsecondaryPaths = p2PsecondaryPaths;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, valueLeafFlags, p2PprimaryPaths, p2PsecondaryPaths);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultResult) {
            DefaultResult other = (DefaultResult) obj;
            return
                Objects.deepEquals(id, other.id) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(p2PprimaryPaths, other.p2PprimaryPaths) &&
                Objects.deepEquals(p2PsecondaryPaths, other.p2PsecondaryPaths);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("id=" + id)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("p2PprimaryPaths=" + p2PprimaryPaths)
            .add("p2PsecondaryPaths=" + p2PsecondaryPaths)
            .toString();
    }


    /**
     * Creates an instance of defaultResult.
     */
    public DefaultResult() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}