/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.yrtietfotntunnel.rev20170311.yrtietfotntunnel.otntetunnelpathcompute.otntetunnelpathcomputeinput.request;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v11.yrtietfotntunnel.rev20170311.yrtietfotntunnel.otntetunnelpathcompute.otntetunnelpathcomputeinput.request.p2psecondarypaths.P2PsecondaryPath;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of p2PsecondaryPaths.
 */
public class DefaultP2PsecondaryPaths extends InnerModelObject implements P2PsecondaryPaths {
    protected List<P2PsecondaryPath> p2PsecondaryPath;

    @Override
    public List<P2PsecondaryPath> p2PsecondaryPath() {
        return p2PsecondaryPath;
    }

    @Override
    public void p2PsecondaryPath(List<P2PsecondaryPath> p2PsecondaryPath) {
        this.p2PsecondaryPath = p2PsecondaryPath;
    }

    @Override
    public void addToP2PsecondaryPath(P2PsecondaryPath addTo) {
        if (p2PsecondaryPath == null) {
            p2PsecondaryPath = new ArrayList<>();
        }
        p2PsecondaryPath.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(p2PsecondaryPath);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultP2PsecondaryPaths) {
            DefaultP2PsecondaryPaths other = (DefaultP2PsecondaryPaths) obj;
            return
                Objects.deepEquals(p2PsecondaryPath, other.p2PsecondaryPath);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("p2PsecondaryPath=" + p2PsecondaryPath)
            .toString();
    }


    /**
     * Creates an instance of defaultP2PsecondaryPaths.
     */
    public DefaultP2PsecondaryPaths() {
    }

}