/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v11.yrtietfotntunnel.rev20170311.yrtietfotntunnel.otntetunnelpathcompute.otntetunnelpathcomputeinput;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.LspEncodingTypes;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.LspProtType;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.PathMetricType;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.SwitchingCapabilities;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.TeGlobalId;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.TeTopologyId;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.TunnelType;
import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.IpAddress;
import org.onosproject.yang.gen.v1.yrtietftransporttypes.rev20161025.yrtietftransporttypes.ClientSignal;
import org.onosproject.yang.gen.v1.yrtietftransporttypes.rev20161025.yrtietftransporttypes.TributaryProtocolType;
import org.onosproject.yang.gen.v1.yrtietftransporttypes.rev20161025.yrtietftransporttypes.TributarySlotGranularity;
import org.onosproject.yang.gen.v11.yrtietfotntunnel.rev20170311.yrtietfotntunnel.otntetunnelpathcompute.otntetunnelpathcomputeinput.request.P2PprimaryPaths;
import org.onosproject.yang.gen.v11.yrtietfotntunnel.rev20170311.yrtietfotntunnel.otntetunnelpathcompute.otntetunnelpathcomputeinput.request.P2PsecondaryPaths;
import org.onosproject.yang.gen.v11.yrtietfotntunnel.rev20170311.yrtietfotntunnel.otntunnelendpoint.DstTributarySlots;
import org.onosproject.yang.gen.v11.yrtietfotntunnel.rev20170311.yrtietfotntunnel.otntunnelendpoint.PayloadTreatmentEnum;
import org.onosproject.yang.gen.v11.yrtietfotntunnel.rev20170311.yrtietfotntunnel.otntunnelendpoint.SrcTributarySlots;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of request.
 */
public class DefaultRequest extends InnerModelObject 
        implements Request, MultiInstanceObject<RequestKeys> {
    protected short id;
    protected Class<? extends TunnelType> type;
    protected IpAddress source;
    protected IpAddress destination;
    protected byte[] srcTpId;
    protected byte[] dstTpId;
    protected Class<? extends SwitchingCapabilities> switchingLayer;
    protected Class<? extends LspEncodingTypes> encoding;
    protected Class<? extends LspProtType> protectionType;
    protected TeGlobalId providerId;
    protected TeGlobalId clientId;
    protected TeTopologyId teTopologyId;
    protected short setupPriority;
    protected short holdPriority;
    protected Class<? extends PathMetricType> tePathMetricType;
    protected Class<? extends TributaryProtocolType> oduType;
    protected PayloadTreatmentEnum payloadTreatment;
    protected Class<? extends ClientSignal> srcClientSignal;
    protected int srcTpn;
    protected Class<? extends TributarySlotGranularity> srcTsg;
    protected int srcTributarySlotCount;
    protected Class<? extends ClientSignal> dstClientSignal;
    protected int dstTpn;
    protected Class<? extends TributarySlotGranularity> dstTsg;
    protected int dstTributarySlotCount;
    protected BitSet valueLeafFlags = new BitSet();
    protected P2PprimaryPaths p2PprimaryPaths;
    protected P2PsecondaryPaths p2PsecondaryPaths;
    protected SrcTributarySlots srcTributarySlots;
    protected DstTributarySlots dstTributarySlots;

    @Override
    public short id() {
        return id;
    }

    @Override
    public Class<? extends TunnelType> type() {
        return type;
    }

    @Override
    public IpAddress source() {
        return source;
    }

    @Override
    public IpAddress destination() {
        return destination;
    }

    @Override
    public byte[] srcTpId() {
        return srcTpId;
    }

    @Override
    public byte[] dstTpId() {
        return dstTpId;
    }

    @Override
    public Class<? extends SwitchingCapabilities> switchingLayer() {
        return switchingLayer;
    }

    @Override
    public Class<? extends LspEncodingTypes> encoding() {
        return encoding;
    }

    @Override
    public Class<? extends LspProtType> protectionType() {
        return protectionType;
    }

    @Override
    public TeGlobalId providerId() {
        return providerId;
    }

    @Override
    public TeGlobalId clientId() {
        return clientId;
    }

    @Override
    public TeTopologyId teTopologyId() {
        return teTopologyId;
    }

    @Override
    public short setupPriority() {
        return setupPriority;
    }

    @Override
    public short holdPriority() {
        return holdPriority;
    }

    @Override
    public Class<? extends PathMetricType> tePathMetricType() {
        return tePathMetricType;
    }

    @Override
    public Class<? extends TributaryProtocolType> oduType() {
        return oduType;
    }

    @Override
    public PayloadTreatmentEnum payloadTreatment() {
        return payloadTreatment;
    }

    @Override
    public Class<? extends ClientSignal> srcClientSignal() {
        return srcClientSignal;
    }

    @Override
    public int srcTpn() {
        return srcTpn;
    }

    @Override
    public Class<? extends TributarySlotGranularity> srcTsg() {
        return srcTsg;
    }

    @Override
    public int srcTributarySlotCount() {
        return srcTributarySlotCount;
    }

    @Override
    public Class<? extends ClientSignal> dstClientSignal() {
        return dstClientSignal;
    }

    @Override
    public int dstTpn() {
        return dstTpn;
    }

    @Override
    public Class<? extends TributarySlotGranularity> dstTsg() {
        return dstTsg;
    }

    @Override
    public int dstTributarySlotCount() {
        return dstTributarySlotCount;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public P2PprimaryPaths p2PprimaryPaths() {
        return p2PprimaryPaths;
    }

    @Override
    public P2PsecondaryPaths p2PsecondaryPaths() {
        return p2PsecondaryPaths;
    }

    @Override
    public SrcTributarySlots srcTributarySlots() {
        return srcTributarySlots;
    }

    @Override
    public DstTributarySlots dstTributarySlots() {
        return dstTributarySlots;
    }

    @Override
    public void id(short id) {
        valueLeafFlags.set(LeafIdentifier.ID.getLeafIndex());
        this.id = id;
    }

    @Override
    public void type(Class<? extends TunnelType> type) {
        valueLeafFlags.set(LeafIdentifier.TYPE.getLeafIndex());
        this.type = type;
    }

    @Override
    public void source(IpAddress source) {
        valueLeafFlags.set(LeafIdentifier.SOURCE.getLeafIndex());
        this.source = source;
    }

    @Override
    public void destination(IpAddress destination) {
        valueLeafFlags.set(LeafIdentifier.DESTINATION.getLeafIndex());
        this.destination = destination;
    }

    @Override
    public void srcTpId(byte[] srcTpId) {
        valueLeafFlags.set(LeafIdentifier.SRCTPID.getLeafIndex());
        this.srcTpId = srcTpId;
    }

    @Override
    public void dstTpId(byte[] dstTpId) {
        valueLeafFlags.set(LeafIdentifier.DSTTPID.getLeafIndex());
        this.dstTpId = dstTpId;
    }

    @Override
    public void switchingLayer(Class<? extends SwitchingCapabilities> switchingLayer) {
        valueLeafFlags.set(LeafIdentifier.SWITCHINGLAYER.getLeafIndex());
        this.switchingLayer = switchingLayer;
    }

    @Override
    public void encoding(Class<? extends LspEncodingTypes> encoding) {
        valueLeafFlags.set(LeafIdentifier.ENCODING.getLeafIndex());
        this.encoding = encoding;
    }

    @Override
    public void protectionType(Class<? extends LspProtType> protectionType) {
        valueLeafFlags.set(LeafIdentifier.PROTECTIONTYPE.getLeafIndex());
        this.protectionType = protectionType;
    }

    @Override
    public void providerId(TeGlobalId providerId) {
        valueLeafFlags.set(LeafIdentifier.PROVIDERID.getLeafIndex());
        this.providerId = providerId;
    }

    @Override
    public void clientId(TeGlobalId clientId) {
        valueLeafFlags.set(LeafIdentifier.CLIENTID.getLeafIndex());
        this.clientId = clientId;
    }

    @Override
    public void teTopologyId(TeTopologyId teTopologyId) {
        valueLeafFlags.set(LeafIdentifier.TETOPOLOGYID.getLeafIndex());
        this.teTopologyId = teTopologyId;
    }

    @Override
    public void setupPriority(short setupPriority) {
        valueLeafFlags.set(LeafIdentifier.SETUPPRIORITY.getLeafIndex());
        this.setupPriority = setupPriority;
    }

    @Override
    public void holdPriority(short holdPriority) {
        valueLeafFlags.set(LeafIdentifier.HOLDPRIORITY.getLeafIndex());
        this.holdPriority = holdPriority;
    }

    @Override
    public void tePathMetricType(Class<? extends PathMetricType> tePathMetricType) {
        valueLeafFlags.set(LeafIdentifier.TEPATHMETRICTYPE.getLeafIndex());
        this.tePathMetricType = tePathMetricType;
    }

    @Override
    public void oduType(Class<? extends TributaryProtocolType> oduType) {
        valueLeafFlags.set(LeafIdentifier.ODUTYPE.getLeafIndex());
        this.oduType = oduType;
    }

    @Override
    public void payloadTreatment(PayloadTreatmentEnum payloadTreatment) {
        valueLeafFlags.set(LeafIdentifier.PAYLOADTREATMENT.getLeafIndex());
        this.payloadTreatment = payloadTreatment;
    }

    @Override
    public void srcClientSignal(Class<? extends ClientSignal> srcClientSignal) {
        valueLeafFlags.set(LeafIdentifier.SRCCLIENTSIGNAL.getLeafIndex());
        this.srcClientSignal = srcClientSignal;
    }

    @Override
    public void srcTpn(int srcTpn) {
        valueLeafFlags.set(LeafIdentifier.SRCTPN.getLeafIndex());
        this.srcTpn = srcTpn;
    }

    @Override
    public void srcTsg(Class<? extends TributarySlotGranularity> srcTsg) {
        valueLeafFlags.set(LeafIdentifier.SRCTSG.getLeafIndex());
        this.srcTsg = srcTsg;
    }

    @Override
    public void srcTributarySlotCount(int srcTributarySlotCount) {
        valueLeafFlags.set(LeafIdentifier.SRCTRIBUTARYSLOTCOUNT.getLeafIndex());
        this.srcTributarySlotCount = srcTributarySlotCount;
    }

    @Override
    public void dstClientSignal(Class<? extends ClientSignal> dstClientSignal) {
        valueLeafFlags.set(LeafIdentifier.DSTCLIENTSIGNAL.getLeafIndex());
        this.dstClientSignal = dstClientSignal;
    }

    @Override
    public void dstTpn(int dstTpn) {
        valueLeafFlags.set(LeafIdentifier.DSTTPN.getLeafIndex());
        this.dstTpn = dstTpn;
    }

    @Override
    public void dstTsg(Class<? extends TributarySlotGranularity> dstTsg) {
        valueLeafFlags.set(LeafIdentifier.DSTTSG.getLeafIndex());
        this.dstTsg = dstTsg;
    }

    @Override
    public void dstTributarySlotCount(int dstTributarySlotCount) {
        valueLeafFlags.set(LeafIdentifier.DSTTRIBUTARYSLOTCOUNT.getLeafIndex());
        this.dstTributarySlotCount = dstTributarySlotCount;
    }

    @Override
    public void p2PprimaryPaths(P2PprimaryPaths p2PprimaryPaths) {
        this.p2PprimaryPaths = p2PprimaryPaths;
    }

    @Override
    public void p2PsecondaryPaths(P2PsecondaryPaths p2PsecondaryPaths) {
        this.p2PsecondaryPaths = p2PsecondaryPaths;
    }

    @Override
    public void srcTributarySlots(SrcTributarySlots srcTributarySlots) {
        this.srcTributarySlots = srcTributarySlots;
    }

    @Override
    public void dstTributarySlots(DstTributarySlots dstTributarySlots) {
        this.dstTributarySlots = dstTributarySlots;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, type, source, destination, srcTpId, dstTpId, switchingLayer, encoding, protectionType, providerId, clientId, teTopologyId, setupPriority, holdPriority, tePathMetricType, oduType, payloadTreatment, srcClientSignal, srcTpn, srcTsg, srcTributarySlotCount, dstClientSignal, dstTpn, dstTsg, dstTributarySlotCount, valueLeafFlags, p2PprimaryPaths, p2PsecondaryPaths, srcTributarySlots, dstTributarySlots);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultRequest) {
            DefaultRequest other = (DefaultRequest) obj;
            return
                Objects.deepEquals(id, other.id) &&
                Objects.deepEquals(type, other.type) &&
                Objects.deepEquals(source, other.source) &&
                Objects.deepEquals(destination, other.destination) &&
                Objects.deepEquals(srcTpId, other.srcTpId) &&
                Objects.deepEquals(dstTpId, other.dstTpId) &&
                Objects.deepEquals(switchingLayer, other.switchingLayer) &&
                Objects.deepEquals(encoding, other.encoding) &&
                Objects.deepEquals(protectionType, other.protectionType) &&
                Objects.deepEquals(providerId, other.providerId) &&
                Objects.deepEquals(clientId, other.clientId) &&
                Objects.deepEquals(teTopologyId, other.teTopologyId) &&
                Objects.deepEquals(setupPriority, other.setupPriority) &&
                Objects.deepEquals(holdPriority, other.holdPriority) &&
                Objects.deepEquals(tePathMetricType, other.tePathMetricType) &&
                Objects.deepEquals(oduType, other.oduType) &&
                Objects.deepEquals(payloadTreatment, other.payloadTreatment) &&
                Objects.deepEquals(srcClientSignal, other.srcClientSignal) &&
                Objects.deepEquals(srcTpn, other.srcTpn) &&
                Objects.deepEquals(srcTsg, other.srcTsg) &&
                Objects.deepEquals(srcTributarySlotCount, other.srcTributarySlotCount) &&
                Objects.deepEquals(dstClientSignal, other.dstClientSignal) &&
                Objects.deepEquals(dstTpn, other.dstTpn) &&
                Objects.deepEquals(dstTsg, other.dstTsg) &&
                Objects.deepEquals(dstTributarySlotCount, other.dstTributarySlotCount) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(p2PprimaryPaths, other.p2PprimaryPaths) &&
                Objects.deepEquals(p2PsecondaryPaths, other.p2PsecondaryPaths) &&
                Objects.deepEquals(srcTributarySlots, other.srcTributarySlots) &&
                Objects.deepEquals(dstTributarySlots, other.dstTributarySlots);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("id=" + id)
            .add("type=" + type)
            .add("source=" + source)
            .add("destination=" + destination)
            .add("srcTpId=" + srcTpId)
            .add("dstTpId=" + dstTpId)
            .add("switchingLayer=" + switchingLayer)
            .add("encoding=" + encoding)
            .add("protectionType=" + protectionType)
            .add("providerId=" + providerId)
            .add("clientId=" + clientId)
            .add("teTopologyId=" + teTopologyId)
            .add("setupPriority=" + setupPriority)
            .add("holdPriority=" + holdPriority)
            .add("tePathMetricType=" + tePathMetricType)
            .add("oduType=" + oduType)
            .add("payloadTreatment=" + payloadTreatment)
            .add("srcClientSignal=" + srcClientSignal)
            .add("srcTpn=" + srcTpn)
            .add("srcTsg=" + srcTsg)
            .add("srcTributarySlotCount=" + srcTributarySlotCount)
            .add("dstClientSignal=" + dstClientSignal)
            .add("dstTpn=" + dstTpn)
            .add("dstTsg=" + dstTsg)
            .add("dstTributarySlotCount=" + dstTributarySlotCount)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("p2PprimaryPaths=" + p2PprimaryPaths)
            .add("p2PsecondaryPaths=" + p2PsecondaryPaths)
            .add("srcTributarySlots=" + srcTributarySlots)
            .add("dstTributarySlots=" + dstTributarySlots)
            .toString();
    }


    /**
     * Creates an instance of defaultRequest.
     */
    public DefaultRequest() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}